/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.test;

import com.navercorp.pinpoint.bootstrap.plugin.test.ExpectedAnnotation;
import com.navercorp.pinpoint.bootstrap.plugin.test.ExpectedTraceField;
import com.navercorp.pinpoint.bootstrap.plugin.test.TraceType;
import java.lang.reflect.Member;

public class ExpectedTrace {
    private final TraceType type;
    private final String serviceType;
    private final Member method;
    private final String methodSignature;
    private final Exception exception;
    private final ExpectedTraceField rpc;
    private final ExpectedTraceField endPoint;
    private final ExpectedTraceField remoteAddr;
    private final ExpectedTraceField destinationId;
    private final ExpectedAnnotation[] annotations;
    private final ExpectedTrace[] asyncTraces;

    private ExpectedTrace(Builder builder) {
        this.type = builder.type;
        this.serviceType = builder.serviceType;
        this.method = builder.method;
        this.methodSignature = builder.methodSignature;
        this.exception = builder.exception;
        this.rpc = builder.rpc;
        this.endPoint = builder.endPoint;
        this.remoteAddr = builder.remoteAddr;
        this.destinationId = builder.destinationId;
        this.annotations = builder.annotations;
        this.asyncTraces = builder.asyncTraces;
    }

    public TraceType getType() {
        return this.type;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public Member getMethod() {
        return this.method;
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public Exception getException() {
        return this.exception;
    }

    public ExpectedTraceField getRpc() {
        return this.rpc;
    }

    public ExpectedTraceField getEndPoint() {
        return this.endPoint;
    }

    public ExpectedTraceField getRemoteAddr() {
        return this.remoteAddr;
    }

    public ExpectedTraceField getDestinationId() {
        return this.destinationId;
    }

    public ExpectedAnnotation[] getAnnotations() {
        return this.annotations;
    }

    public ExpectedTrace[] getAsyncTraces() {
        return this.asyncTraces;
    }

    public static Builder createBuilder(TraceType traceType, String serviceType) {
        return new Builder(traceType, serviceType);
    }

    public static Builder createRootBuilder(String serviceType) {
        return new Builder(TraceType.ROOT, serviceType);
    }

    public static Builder createEventBuilder(String serviceType) {
        return new Builder(TraceType.EVENT, serviceType);
    }

    public static class Builder {
        private final TraceType type;
        private final String serviceType;
        private Member method;
        private String methodSignature;
        private Exception exception;
        private ExpectedTraceField rpc = ExpectedTraceField.ALWAYS_TRUE;
        private ExpectedTraceField endPoint = ExpectedTraceField.ALWAYS_TRUE;
        private ExpectedTraceField remoteAddr = ExpectedTraceField.ALWAYS_TRUE;
        private ExpectedTraceField destinationId = ExpectedTraceField.ALWAYS_TRUE;
        private ExpectedAnnotation[] annotations;
        private ExpectedTrace[] asyncTraces;

        public Builder(TraceType type, String serviceType) {
            if (type == null) {
                throw new NullPointerException("type must not be null");
            }
            if (serviceType == null) {
                throw new NullPointerException("serviceType must not be null");
            }
            this.type = type;
            this.serviceType = serviceType;
        }

        public void setMethod(Member method) {
            this.method = method;
        }

        public void setMethodSignature(String methodSignature) {
            this.methodSignature = methodSignature;
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }

        public void setRpc(String rpc) {
            this.setRpc(ExpectedTraceField.create(rpc));
        }

        public void setRpc(ExpectedTraceField rpc) {
            if (rpc == null) {
                throw new NullPointerException("rpc must not be null");
            }
            this.rpc = rpc;
        }

        public void setEndPoint(String endPoint) {
            this.setEndPoint(ExpectedTraceField.create(endPoint));
        }

        public void setEndPoint(ExpectedTraceField endPoint) {
            if (endPoint == null) {
                throw new NullPointerException("endPoint must not be null");
            }
            this.endPoint = endPoint;
        }

        public void setRemoteAddr(String remoteAddr) {
            this.setRemoteAddr(ExpectedTraceField.create(remoteAddr));
        }

        public void setRemoteAddr(ExpectedTraceField remoteAddr) {
            if (remoteAddr == null) {
                throw new NullPointerException("remoteAddr must not be null");
            }
            this.remoteAddr = remoteAddr;
        }

        public void setDestinationId(String destinationId) {
            this.setDestinationId(ExpectedTraceField.create(destinationId));
        }

        public void setDestinationId(ExpectedTraceField destinationId) {
            if (destinationId == null) {
                throw new NullPointerException("destinationId must not be null");
            }
            this.destinationId = destinationId;
        }

        public void setAnnotations(ExpectedAnnotation ... annotations) {
            this.annotations = annotations;
        }

        public void setAsyncTraces(ExpectedTrace[] asyncTraces) {
            this.asyncTraces = asyncTraces;
        }

        public ExpectedTrace build() {
            return new ExpectedTrace(this);
        }
    }
}

