/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.java9.module;

import com.navercorp.pinpoint.bootstrap.java9.module.PackageAnalyzer;
import com.navercorp.pinpoint.common.util.ClassUtils;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarPackageAnalyzer
implements PackageAnalyzer {
    private static final String META_INF = "META-INF/";
    private static final String CLASS_EXTENSION = ".class";
    private final JarFile jarFile;
    private final JarEntryFilter filter;

    public JarPackageAnalyzer(JarFile jarFile) {
        if (jarFile == null) {
            throw new NullPointerException("jarFile must not be null");
        }
        this.jarFile = jarFile;
        this.filter = new PackageFilter();
    }

    @Override
    public Set<String> getPackage() {
        HashSet<String> packageSet = new HashSet<String>();
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String packageName = this.filter.filter(jarEntry);
            if (packageName == null) continue;
            packageSet.add(packageName);
        }
        return packageSet;
    }

    static class PackageFilter
    implements JarEntryFilter {
        PackageFilter() {
        }

        @Override
        public String filter(JarEntry jarEntry) {
            if (jarEntry.getName().startsWith(JarPackageAnalyzer.META_INF)) {
                return null;
            }
            if (jarEntry.isDirectory()) {
                return null;
            }
            String fileName = jarEntry.getName();
            if (!this.checkFIleExtension(fileName, JarPackageAnalyzer.CLASS_EXTENSION)) {
                return null;
            }
            String packageName = ClassUtils.getPackageName((String)fileName, (char)'/', null);
            if (packageName == null) {
                return null;
            }
            return this.toPackageName(packageName);
        }

        private boolean checkFIleExtension(String fileName, String extension) {
            return fileName.endsWith(extension);
        }

        private String toPackageName(String dirFormat) {
            if (dirFormat == null) {
                return null;
            }
            return dirFormat.replace('/', '.');
        }
    }

    static interface JarEntryFilter {
        public String filter(JarEntry var1);
    }
}

