/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx;

import com.navercorp.pinpoint.bootstrap.plugin.ApplicationTypeDetector;
import com.navercorp.pinpoint.bootstrap.resolver.ConditionProvider;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.common.util.CollectionUtils;
import com.navercorp.pinpoint.plugin.vertx.VertxConstants;
import java.util.Arrays;
import java.util.List;

public class VertxDetector
implements ApplicationTypeDetector {
    private static final String DEFAULT_BOOTSTRAP_MAIN = "io.vertx.core.Starter";
    private static final String REQUIRED_CLASS = "io.vertx.core.Starter";
    private final List<String> bootstrapMains;

    public VertxDetector(List<String> bootstrapMains) {
        this.bootstrapMains = CollectionUtils.isEmpty(bootstrapMains) ? Arrays.asList("io.vertx.core.Starter") : bootstrapMains;
    }

    public ServiceType getApplicationType() {
        return VertxConstants.VERTX;
    }

    public boolean detect(ConditionProvider provider) {
        return provider.checkMainClass(this.bootstrapMains) && provider.checkForClass("io.vertx.core.Starter");
    }
}

