/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.Configuration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConfigurationUtils;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.ConversionException;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.PrefixedKeysIterator;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.PropertyConverter;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.SubsetConfiguration;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationErrorEvent;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.ConfigurationErrorListener;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.event.EventSource;
import com.secnium.iast.thirdparty.org.apache.commons.configuration.interpol.ConfigurationInterpolator;
import com.secnium.iast.thirdparty.org.apache.commons.lang.BooleanUtils;
import com.secnium.iast.thirdparty.org.apache.commons.lang.ClassUtils;
import com.secnium.iast.thirdparty.org.apache.commons.lang.ObjectUtils;
import com.secnium.iast.thirdparty.org.apache.commons.lang.text.StrLookup;
import com.secnium.iast.thirdparty.org.apache.commons.lang.text.StrSubstitutor;
import com.secnium.iast.thirdparty.org.apache.commons.logging.Log;
import com.secnium.iast.thirdparty.org.apache.commons.logging.impl.NoOpLog;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfiguration
extends EventSource
implements Configuration {
    public static final int EVENT_ADD_PROPERTY = 1;
    public static final int EVENT_CLEAR_PROPERTY = 2;
    public static final int EVENT_SET_PROPERTY = 3;
    public static final int EVENT_CLEAR = 4;
    public static final int EVENT_READ_PROPERTY = 5;
    protected static final String START_TOKEN = "${";
    protected static final String END_TOKEN = "}";
    private static final char DISABLED_DELIMITER = '\u0000';
    private static char defaultListDelimiter = (char)44;
    private char listDelimiter = defaultListDelimiter;
    private boolean delimiterParsingDisabled;
    private boolean throwExceptionOnMissing;
    private StrSubstitutor substitutor;
    private Log log;

    public AbstractConfiguration() {
        this.setLogger(null);
    }

    public static void setDefaultListDelimiter(char c2) {
        defaultListDelimiter = c2;
    }

    @Deprecated
    public static void setDelimiter(char c2) {
        AbstractConfiguration.setDefaultListDelimiter(c2);
    }

    public static char getDefaultListDelimiter() {
        return defaultListDelimiter;
    }

    @Deprecated
    public static char getDelimiter() {
        return AbstractConfiguration.getDefaultListDelimiter();
    }

    public void setListDelimiter(char c2) {
        this.listDelimiter = c2;
    }

    public char getListDelimiter() {
        return this.listDelimiter;
    }

    public boolean isDelimiterParsingDisabled() {
        return this.delimiterParsingDisabled;
    }

    public void setDelimiterParsingDisabled(boolean bl) {
        this.delimiterParsingDisabled = bl;
    }

    public void setThrowExceptionOnMissing(boolean bl) {
        this.throwExceptionOnMissing = bl;
    }

    public boolean isThrowExceptionOnMissing() {
        return this.throwExceptionOnMissing;
    }

    public synchronized StrSubstitutor getSubstitutor() {
        if (this.substitutor == null) {
            this.substitutor = new StrSubstitutor(this.createInterpolator());
        }
        return this.substitutor;
    }

    public ConfigurationInterpolator getInterpolator() {
        return (ConfigurationInterpolator)this.getSubstitutor().getVariableResolver();
    }

    protected ConfigurationInterpolator createInterpolator() {
        ConfigurationInterpolator configurationInterpolator = new ConfigurationInterpolator();
        configurationInterpolator.setDefaultLookup(new StrLookup(){

            public String lookup(String string) {
                Object object = AbstractConfiguration.this.resolveContainerStore(string);
                return object != null ? object.toString() : null;
            }
        });
        return configurationInterpolator;
    }

    public Log getLogger() {
        return this.log;
    }

    public void setLogger(Log log) {
        this.log = log != null ? log : new NoOpLog();
    }

    public void addErrorLogListener() {
        this.addErrorListener(new ConfigurationErrorListener(){

            public void configurationError(ConfigurationErrorEvent configurationErrorEvent) {
                AbstractConfiguration.this.getLogger().warn("Internal error", configurationErrorEvent.getCause());
            }
        });
    }

    @Override
    public void addProperty(String string, Object object) {
        this.fireEvent(1, string, object, true);
        this.addPropertyValues(string, object, this.isDelimiterParsingDisabled() ? (char)'\u0000' : this.getListDelimiter());
        this.fireEvent(1, string, object, false);
    }

    protected abstract void addPropertyDirect(String var1, Object var2);

    private void addPropertyValues(String string, Object object, char c2) {
        Iterator<?> iterator = PropertyConverter.toIterator(object, c2);
        while (iterator.hasNext()) {
            this.addPropertyDirect(string, iterator.next());
        }
    }

    protected String interpolate(String string) {
        Object object = this.interpolate((Object)string);
        return object == null ? null : object.toString();
    }

    protected Object interpolate(Object object) {
        return PropertyConverter.interpolate(object, this);
    }

    @Deprecated
    protected String interpolateHelper(String string, List<?> list) {
        return string;
    }

    @Override
    public Configuration subset(String string) {
        return new SubsetConfiguration(this, string, ".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setProperty(String string, Object object) {
        this.fireEvent(3, string, object, true);
        this.setDetailEvents(false);
        try {
            this.clearProperty(string);
            this.addProperty(string, object);
        }
        finally {
            this.setDetailEvents(true);
        }
        this.fireEvent(3, string, object, false);
    }

    @Override
    public void clearProperty(String string) {
        this.fireEvent(2, string, null, true);
        this.clearPropertyDirect(string);
        this.fireEvent(2, string, null, false);
    }

    protected void clearPropertyDirect(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.fireEvent(4, null, null, true);
        this.setDetailEvents(false);
        boolean bl = true;
        try {
            Iterator<String> iterator = this.getKeys();
            while (iterator.hasNext()) {
                String string = iterator.next();
                if (bl) {
                    try {
                        iterator.remove();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        bl = false;
                    }
                }
                if (bl && this.containsKey(string)) {
                    bl = false;
                }
                if (bl) continue;
                this.clearProperty(string);
            }
        }
        finally {
            this.setDetailEvents(true);
        }
        this.fireEvent(4, null, null, false);
    }

    @Override
    public Iterator<String> getKeys(String string) {
        return new PrefixedKeysIterator(this.getKeys(), string);
    }

    @Override
    public Properties getProperties(String string) {
        return this.getProperties(string, null);
    }

    public Properties getProperties(String string, Properties properties) {
        String[] stringArray = this.getStringArray(string);
        Properties properties2 = properties == null ? new Properties() : new Properties(properties);
        for (String string2 : stringArray) {
            int n = string2.indexOf(61);
            if (n <= 0) {
                if (stringArray.length == 1 && "".equals(string2)) break;
                throw new IllegalArgumentException('\'' + string2 + "' does not contain an equals sign");
            }
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            properties2.put(string3, string4);
        }
        return properties2;
    }

    @Override
    public boolean getBoolean(String string) {
        Boolean bl = this.getBoolean(string, null);
        if (bl != null) {
            return bl;
        }
        throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
    }

    @Override
    public boolean getBoolean(String string, boolean bl) {
        return this.getBoolean(string, BooleanUtils.toBooleanObject(bl));
    }

    @Override
    public Boolean getBoolean(String string, Boolean bl) {
        Object object = this.resolveContainerStore(string);
        if (object == null) {
            return bl;
        }
        try {
            return PropertyConverter.toBoolean(this.interpolate(object));
        }
        catch (ConversionException conversionException) {
            throw new ConversionException('\'' + string + "' doesn't map to a Boolean object", conversionException);
        }
    }

    @Override
    public byte getByte(String string) {
        Byte by = this.getByte(string, null);
        if (by != null) {
            return by;
        }
        throw new NoSuchElementException('\'' + string + " doesn't map to an existing object");
    }

    @Override
    public byte getByte(String string, byte by) {
        return this.getByte(string, new Byte(by));
    }

    @Override
    public Byte getByte(String string, Byte by) {
        Object object = this.resolveContainerStore(string);
        if (object == null) {
            return by;
        }
        try {
            return PropertyConverter.toByte(this.interpolate(object));
        }
        catch (ConversionException conversionException) {
            throw new ConversionException('\'' + string + "' doesn't map to a Byte object", conversionException);
        }
    }

    @Override
    public double getDouble(String string) {
        Double d2 = this.getDouble(string, null);
        if (d2 != null) {
            return d2;
        }
        throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
    }

    @Override
    public double getDouble(String string, double d2) {
        return this.getDouble(string, new Double(d2));
    }

    @Override
    public Double getDouble(String string, Double d2) {
        Object object = this.resolveContainerStore(string);
        if (object == null) {
            return d2;
        }
        try {
            return PropertyConverter.toDouble(this.interpolate(object));
        }
        catch (ConversionException conversionException) {
            throw new ConversionException('\'' + string + "' doesn't map to a Double object", conversionException);
        }
    }

    @Override
    public float getFloat(String string) {
        Float f2 = this.getFloat(string, null);
        if (f2 != null) {
            return f2.floatValue();
        }
        throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
    }

    @Override
    public float getFloat(String string, float f2) {
        return this.getFloat(string, new Float(f2)).floatValue();
    }

    @Override
    public Float getFloat(String string, Float f2) {
        Object object = this.resolveContainerStore(string);
        if (object == null) {
            return f2;
        }
        try {
            return PropertyConverter.toFloat(this.interpolate(object));
        }
        catch (ConversionException conversionException) {
            throw new ConversionException('\'' + string + "' doesn't map to a Float object", conversionException);
        }
    }

    @Override
    public int getInt(String string) {
        Integer n = this.getInteger(string, null);
        if (n != null) {
            return n;
        }
        throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
    }

    @Override
    public int getInt(String string, int n) {
        Integer n2 = this.getInteger(string, null);
        if (n2 == null) {
            return n;
        }
        return n2;
    }

    @Override
    public Integer getInteger(String string, Integer n) {
        Object object = this.resolveContainerStore(string);
        if (object == null) {
            return n;
        }
        try {
            return PropertyConverter.toInteger(this.interpolate(object));
        }
        catch (ConversionException conversionException) {
            throw new ConversionException('\'' + string + "' doesn't map to an Integer object", conversionException);
        }
    }

    @Override
    public long getLong(String string) {
        Long l = this.getLong(string, null);
        if (l != null) {
            return l;
        }
        throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
    }

    @Override
    public long getLong(String string, long l) {
        return this.getLong(string, new Long(l));
    }

    @Override
    public Long getLong(String string, Long l) {
        Object object = this.resolveContainerStore(string);
        if (object == null) {
            return l;
        }
        try {
            return PropertyConverter.toLong(this.interpolate(object));
        }
        catch (ConversionException conversionException) {
            throw new ConversionException('\'' + string + "' doesn't map to a Long object", conversionException);
        }
    }

    @Override
    public short getShort(String string) {
        Short s = this.getShort(string, null);
        if (s != null) {
            return s;
        }
        throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
    }

    @Override
    public short getShort(String string, short s) {
        return this.getShort(string, new Short(s));
    }

    @Override
    public Short getShort(String string, Short s) {
        Object object = this.resolveContainerStore(string);
        if (object == null) {
            return s;
        }
        try {
            return PropertyConverter.toShort(this.interpolate(object));
        }
        catch (ConversionException conversionException) {
            throw new ConversionException('\'' + string + "' doesn't map to a Short object", conversionException);
        }
    }

    @Override
    public BigDecimal getBigDecimal(String string) {
        BigDecimal bigDecimal = this.getBigDecimal(string, null);
        if (bigDecimal != null) {
            return bigDecimal;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(String string, BigDecimal bigDecimal) {
        Object object = this.resolveContainerStore(string);
        if (object == null) {
            return bigDecimal;
        }
        try {
            return PropertyConverter.toBigDecimal(this.interpolate(object));
        }
        catch (ConversionException conversionException) {
            throw new ConversionException('\'' + string + "' doesn't map to a BigDecimal object", conversionException);
        }
    }

    @Override
    public BigInteger getBigInteger(String string) {
        BigInteger bigInteger = this.getBigInteger(string, null);
        if (bigInteger != null) {
            return bigInteger;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
        }
        return null;
    }

    @Override
    public BigInteger getBigInteger(String string, BigInteger bigInteger) {
        Object object = this.resolveContainerStore(string);
        if (object == null) {
            return bigInteger;
        }
        try {
            return PropertyConverter.toBigInteger(this.interpolate(object));
        }
        catch (ConversionException conversionException) {
            throw new ConversionException('\'' + string + "' doesn't map to a BigInteger object", conversionException);
        }
    }

    @Override
    public String getString(String string) {
        String string2 = this.getString(string, null);
        if (string2 != null) {
            return string2;
        }
        if (this.isThrowExceptionOnMissing()) {
            throw new NoSuchElementException('\'' + string + "' doesn't map to an existing object");
        }
        return null;
    }

    @Override
    public String getString(String string, String string2) {
        Object object = this.resolveContainerStore(string);
        if (object instanceof String) {
            return this.interpolate((String)object);
        }
        if (object == null) {
            return this.interpolate(string2);
        }
        throw new ConversionException('\'' + string + "' doesn't map to a String object");
    }

    @Override
    public String[] getStringArray(String string) {
        String[] stringArray;
        Object object = this.getProperty(string);
        if (object instanceof String) {
            stringArray = new String[]{this.interpolate((String)object)};
        } else if (object instanceof List) {
            List list = (List)object;
            stringArray = new String[list.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.interpolate(ObjectUtils.toString(list.get(i), null));
            }
        } else if (object == null) {
            stringArray = new String[]{};
        } else if (this.isScalarValue(object)) {
            stringArray = new String[]{object.toString()};
        } else {
            throw new ConversionException('\'' + string + "' doesn't map to a String/List object");
        }
        return stringArray;
    }

    @Override
    public List<Object> getList(String string) {
        return this.getList(string, new ArrayList());
    }

    @Override
    public List<Object> getList(String string, List<?> list) {
        ArrayList<Object> arrayList;
        Object object = this.getProperty(string);
        if (object instanceof String) {
            arrayList = new ArrayList<String>(1);
            arrayList.add(this.interpolate((String)object));
        } else if (object instanceof List) {
            arrayList = new ArrayList();
            List list2 = (List)object;
            for (Object e2 : list2) {
                arrayList.add(this.interpolate(e2));
            }
        } else if (object == null) {
            arrayList = list;
        } else {
            if (object.getClass().isArray()) {
                return Arrays.asList((Object[])object);
            }
            if (this.isScalarValue(object)) {
                return Collections.singletonList(object.toString());
            }
            throw new ConversionException('\'' + string + "' doesn't map to a List object: " + object + ", a " + object.getClass().getName());
        }
        return arrayList;
    }

    protected Object resolveContainerStore(String string) {
        Object object = this.getProperty(string);
        if (object != null) {
            if (object instanceof Collection) {
                Collection collection = (Collection)object;
                object = collection.isEmpty() ? null : collection.iterator().next();
            } else if (object.getClass().isArray() && Array.getLength(object) > 0) {
                object = Array.get(object, 0);
            }
        }
        return object;
    }

    protected boolean isScalarValue(Object object) {
        return ClassUtils.wrapperToPrimitive(object.getClass()) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(Configuration configuration) {
        if (configuration != null) {
            Iterator<String> iterator = configuration.getKeys();
            while (iterator.hasNext()) {
                String string = iterator.next();
                Object object = configuration.getProperty(string);
                this.fireEvent(3, string, object, true);
                this.setDetailEvents(false);
                try {
                    this.clearProperty(string);
                    this.addPropertyValues(string, object, '\u0000');
                }
                finally {
                    this.setDetailEvents(true);
                }
                this.fireEvent(3, string, object, false);
            }
        }
    }

    public void append(Configuration configuration) {
        if (configuration != null) {
            Iterator<String> iterator = configuration.getKeys();
            while (iterator.hasNext()) {
                String string = iterator.next();
                Object object = configuration.getProperty(string);
                this.fireEvent(1, string, object, true);
                this.addPropertyValues(string, object, '\u0000');
                this.fireEvent(1, string, object, false);
            }
        }
    }

    public Configuration interpolatedConfiguration() {
        AbstractConfiguration abstractConfiguration = (AbstractConfiguration)ConfigurationUtils.cloneConfiguration(this);
        abstractConfiguration.setDelimiterParsingDisabled(true);
        Iterator<String> iterator = this.getKeys();
        while (iterator.hasNext()) {
            String string = iterator.next();
            abstractConfiguration.setProperty(string, this.getList(string));
        }
        abstractConfiguration.setDelimiterParsingDisabled(this.isDelimiterParsingDisabled());
        return abstractConfiguration;
    }
}

