/*
 * Decompiled with CFR 0.152.
 */
package com.secnium.iast.thirdparty.org.apache.commons.configuration.tree;

import com.secnium.iast.thirdparty.org.apache.commons.configuration.tree.ConfigurationNode;
import java.io.PrintStream;
import java.util.Iterator;

public final class TreeUtils {
    private TreeUtils() {
    }

    public static void printTree(PrintStream printStream, ConfigurationNode configurationNode) {
        if (printStream != null) {
            TreeUtils.printTree(printStream, "", configurationNode);
        }
    }

    private static void printTree(PrintStream printStream, String string, ConfigurationNode configurationNode) {
        StringBuffer stringBuffer = new StringBuffer(string).append("<").append(configurationNode.getName());
        for (ConfigurationNode configurationNode2 : configurationNode.getAttributes()) {
            stringBuffer.append(" ").append(configurationNode2.getName()).append("='").append(configurationNode2.getValue()).append("'");
        }
        stringBuffer.append(">");
        printStream.print(stringBuffer.toString());
        if (configurationNode.getValue() != null) {
            printStream.print(configurationNode.getValue());
        }
        boolean bl = false;
        if (configurationNode.getChildrenCount() > 0) {
            printStream.print("\n");
            Iterator<ConfigurationNode> iterator = configurationNode.getChildren().iterator();
            while (iterator.hasNext()) {
                TreeUtils.printTree(printStream, string + "  ", iterator.next());
            }
            bl = true;
        }
        if (bl) {
            printStream.print(string);
        }
        printStream.println("</" + configurationNode.getName() + ">");
    }
}

