/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.rpc.client;

import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.rpc.MessageListener;
import com.navercorp.pinpoint.rpc.StateChangeEventListener;
import com.navercorp.pinpoint.rpc.client.ClientHandlerFactory;
import com.navercorp.pinpoint.rpc.client.ClientOption;
import com.navercorp.pinpoint.rpc.client.ConnectionFactory;
import com.navercorp.pinpoint.rpc.client.DefaultPinpointClientHandler;
import com.navercorp.pinpoint.rpc.client.HandshakerFactory;
import com.navercorp.pinpoint.rpc.client.PinpointClientHandler;
import com.navercorp.pinpoint.rpc.client.PinpointClientHandshaker;
import com.navercorp.pinpoint.rpc.client.SocketAddressProvider;
import com.navercorp.pinpoint.rpc.cluster.ClusterOption;
import com.navercorp.pinpoint.rpc.stream.ServerStreamChannelMessageListener;
import java.util.List;
import org.jboss.netty.util.Timer;

public class DefaultPinpointClientHandlerFactory
implements ClientHandlerFactory {
    private final ClientOption clientOption;
    private final ClusterOption clusterOption;
    private final HandshakerFactory handshakerFactory;
    private final MessageListener messageListener;
    private final ServerStreamChannelMessageListener serverStreamChannelMessageListener;
    private final List<StateChangeEventListener> stateChangeEventListeners;

    public DefaultPinpointClientHandlerFactory(ClientOption clientOption, ClusterOption clusterOption, HandshakerFactory handshakerFactory, MessageListener messageListener, ServerStreamChannelMessageListener serverStreamChannelMessageListener, List<StateChangeEventListener> stateChangeEventListeners) {
        this.clientOption = (ClientOption)Assert.requireNonNull((Object)clientOption, (String)"clientOption must not be null");
        this.clusterOption = (ClusterOption)Assert.requireNonNull((Object)clusterOption, (String)"clusterOption must not be null");
        this.handshakerFactory = (HandshakerFactory)Assert.requireNonNull((Object)handshakerFactory, (String)"handshakerFactory must not be null");
        this.messageListener = (MessageListener)Assert.requireNonNull((Object)messageListener, (String)"messageListener must not be null");
        this.serverStreamChannelMessageListener = (ServerStreamChannelMessageListener)Assert.requireNonNull((Object)serverStreamChannelMessageListener, (String)"serverStreamChannelMessageListener must not be null");
        this.stateChangeEventListeners = (List)Assert.requireNonNull(stateChangeEventListeners, (String)"stateChangeEventListeners must not be null");
    }

    @Override
    public PinpointClientHandler newClientHandler(ConnectionFactory connectionFactory, SocketAddressProvider remoteAddressProvider, Timer channelTimer, boolean reconnect) {
        PinpointClientHandshaker handshaker = this.handshakerFactory.newHandShaker(channelTimer);
        DefaultPinpointClientHandler clientHandler = new DefaultPinpointClientHandler(connectionFactory, remoteAddressProvider, handshaker, this.clusterOption, this.clientOption, channelTimer, this.messageListener, this.serverStreamChannelMessageListener, this.stateChangeEventListeners);
        if (reconnect) {
            clientHandler.initReconnect();
        }
        return clientHandler;
    }
}

