/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.instrument.lambda;

import com.navercorp.pinpoint.bootstrap.instrument.lambda.LambdaBytecodeHandler;
import com.navercorp.pinpoint.common.util.Assert;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LambdaBytecodeLogger
implements LambdaBytecodeHandler {
    private final Logger logger;
    private final LambdaBytecodeHandler delegate;

    public LambdaBytecodeLogger(LambdaBytecodeHandler delegate) {
        this.delegate = (LambdaBytecodeHandler)Assert.requireNonNull((Object)delegate, (String)"delegate must not be null");
        this.logger = LoggerFactory.getLogger(delegate.getClass());
    }

    public byte[] handleLambdaBytecode(Class<?> hostClass, byte[] data, Object[] cpPatches) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("handleLambdaBytecode {} {}", hostClass, (Object)Arrays.toString(cpPatches));
        }
        return this.delegate.handleLambdaBytecode(hostClass, data, cpPatches);
    }
}

