/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler;

import com.google.inject.Inject;
import com.navercorp.pinpoint.bootstrap.instrument.RequestHandle;
import com.navercorp.pinpoint.profiler.DynamicTransformerRegistry;
import com.navercorp.pinpoint.profiler.ProfilerException;
import com.navercorp.pinpoint.profiler.util.JavaAssistUtils;
import java.lang.instrument.ClassFileTransformer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDynamicTransformerRegistry
implements DynamicTransformerRegistry {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ConcurrentMap<TransformerKey, ClassFileTransformer> transformerMap = new ConcurrentHashMap<TransformerKey, ClassFileTransformer>();

    @Inject
    public DefaultDynamicTransformerRegistry() {
    }

    public RequestHandle onRetransformRequest(Class<?> target, ClassFileTransformer transformer) {
        if (target == null) {
            throw new NullPointerException("target must not be null");
        }
        if (transformer == null) {
            throw new NullPointerException("transformer must not be null");
        }
        TransformerKey key = this.createTransformKey(target);
        this.add(key, transformer);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("added retransformer classLoader: {}, class: {}, registry size: {}", new Object[]{target.getClassLoader(), target.getName(), this.transformerMap.size()});
        }
        return new DefaultRequestHandle(key);
    }

    public void onTransformRequest(ClassLoader classLoader, String targetClassName, ClassFileTransformer transformer) {
        TransformerKey transformKey = this.createTransformKey(classLoader, targetClassName);
        this.add(transformKey, transformer);
        if (this.logger.isInfoEnabled()) {
            this.logger.info("added dynamic transformer classLoader: {}, className: {}, registry size: {}", new Object[]{classLoader, targetClassName, this.transformerMap.size()});
        }
    }

    private void add(TransformerKey key, ClassFileTransformer transformer) {
        ClassFileTransformer prev = this.transformerMap.putIfAbsent(key, transformer);
        if (prev != null) {
            throw new ProfilerException("Transformer already exists. TransformKey: " + key + ", transformer: " + prev);
        }
    }

    private TransformerKey createTransformKey(ClassLoader classLoader, String targetClassName) {
        String classInternName = JavaAssistUtils.javaNameToJvmName(targetClassName);
        return new TransformerKey(classLoader, classInternName);
    }

    private TransformerKey createTransformKey(Class<?> targetClass) {
        ClassLoader classLoader = targetClass.getClassLoader();
        String targetClassName = targetClass.getName();
        return this.createTransformKey(classLoader, targetClassName);
    }

    @Override
    public ClassFileTransformer getTransformer(ClassLoader classLoader, String targetClassName) {
        if (this.transformerMap.isEmpty()) {
            return null;
        }
        TransformerKey key = new TransformerKey(classLoader, targetClassName);
        ClassFileTransformer transformer = (ClassFileTransformer)this.transformerMap.remove(key);
        if (transformer != null && this.logger.isInfoEnabled()) {
            this.logger.info("removed dynamic transformer classLoader: {}, className: {}, registry size: {}", new Object[]{classLoader, targetClassName, this.transformerMap.size()});
        }
        return transformer;
    }

    int size() {
        return this.transformerMap.size();
    }

    private class DefaultRequestHandle
    implements RequestHandle {
        private final TransformerKey key;

        public DefaultRequestHandle(TransformerKey key) {
            if (key == null) {
                throw new NullPointerException("key must not be null");
            }
            this.key = key;
        }

        public boolean cancel() {
            ClassFileTransformer remove = (ClassFileTransformer)DefaultDynamicTransformerRegistry.this.transformerMap.remove(this.key);
            return remove != null;
        }
    }

    private static final class TransformerKey {
        private final ClassLoader classLoader;
        private final String targetClassInternalName;

        public TransformerKey(ClassLoader classLoader, String targetClassInternalName) {
            if (targetClassInternalName == null) {
                throw new NullPointerException("targetClassInternalName must not be null");
            }
            this.classLoader = classLoader;
            this.targetClassInternalName = targetClassInternalName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransformerKey that = (TransformerKey)o;
            if (this.classLoader != null ? !this.classLoader.equals(that.classLoader) : that.classLoader != null) {
                return false;
            }
            return this.targetClassInternalName.equals(that.targetClassInternalName);
        }

        public int hashCode() {
            int result = this.classLoader != null ? this.classLoader.hashCode() : 0;
            result = 31 * result + this.targetClassInternalName.hashCode();
            return result;
        }

        public String toString() {
            return "TransformerKey{classLoader=" + this.classLoader + ", targetClassInternalName='" + this.targetClassInternalName + '\'' + '}';
        }
    }
}

