/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.kafka.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.kafka.KafkaConstants;
import com.navercorp.pinpoint.plugin.kafka.interceptor.ConsumerRecordEntryPointInterceptor;
import com.navercorp.pinpoint.plugin.kafka.interceptor.ConsumerRecordsDesc;
import java.util.concurrent.atomic.AtomicReference;

public class ConsumerMultiRecordEntryPointInterceptor
extends ConsumerRecordEntryPointInterceptor {
    private final AtomicReference<TraceFactoryProvider.TraceFactory> tracyFactoryReference = new AtomicReference();

    public ConsumerMultiRecordEntryPointInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor, int parameterIndex) {
        super(traceContext, methodDescriptor, parameterIndex);
    }

    @Override
    protected Trace createTrace(Object target, Object[] args) {
        ConsumerRecordsDesc consumerRecordsDesc = this.getConsumerRecordsDesc(args);
        if (consumerRecordsDesc == null) {
            return null;
        }
        Trace newTrace = this.createTrace(consumerRecordsDesc);
        return newTrace;
    }

    private ConsumerRecordsDesc getConsumerRecordsDesc(Object[] args) {
        return ConsumerRecordsDesc.create(this.getTargetParameter(args));
    }

    private Trace createTrace(ConsumerRecordsDesc consumerRecordsDesc) {
        TraceFactoryProvider.TraceFactory createTrace = this.tracyFactoryReference.get();
        if (createTrace == null) {
            createTrace = TraceFactoryProvider.get();
            this.tracyFactoryReference.compareAndSet(null, createTrace);
        }
        return createTrace.createTrace(this.traceContext, consumerRecordsDesc);
    }

    private static class TraceFactoryProvider {
        private TraceFactoryProvider() {
        }

        private static TraceFactory get() {
            return new DefaultTraceFactory();
        }

        private static class DefaultTraceFactory
        implements TraceFactory {
            final PLogger logger = PLoggerFactory.getLogger(this.getClass());

            private DefaultTraceFactory() {
            }

            @Override
            public Trace createTrace(TraceContext traceContext, ConsumerRecordsDesc consumerRecordsDesc) {
                Trace trace = traceContext.newTraceObject();
                if (trace.canSampled()) {
                    SpanRecorder recorder = trace.getSpanRecorder();
                    this.recordRootSpan(recorder, consumerRecordsDesc);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("TraceID not exist. start new trace.");
                    }
                    return trace;
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("TraceID not exist. camSampled is false. skip trace.");
                }
                return null;
            }

            private void recordRootSpan(SpanRecorder recorder, ConsumerRecordsDesc consumerRecordsDesc) {
                recorder.recordServiceType(KafkaConstants.KAFKA_CLIENT);
                recorder.recordApi((MethodDescriptor)ConsumerRecordEntryPointInterceptor.ENTRY_POINT_METHOD_DESCRIPTOR);
                int size = consumerRecordsDesc.size();
                String remoteAddress = consumerRecordsDesc.getRemoteAddress();
                recorder.recordEndPoint(remoteAddress);
                recorder.recordRemoteAddress(remoteAddress);
                recorder.recordAcceptorHost(remoteAddress);
                String topic = consumerRecordsDesc.getTopicString();
                recorder.recordRpcName(this.createRpcName(topic, size));
                recorder.recordAttribute(KafkaConstants.KAFKA_TOPIC_ANNOTATION_KEY, topic);
                recorder.recordAttribute(KafkaConstants.KAFKA_BATCH_ANNOTATION_KEY, size);
            }

            private String createRpcName(String topic, int count) {
                StringBuilder rpcName = new StringBuilder("kafka://");
                rpcName.append("topic=").append(topic);
                rpcName.append("?batch=").append(count);
                return rpcName.toString();
            }
        }

        private static interface TraceFactory {
            public Trace createTrace(TraceContext var1, ConsumerRecordsDesc var2);
        }
    }
}

