/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.okhttp.v3.interceptor;

import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.SpanEventSimpleAroundInterceptorForPlugin;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.plugin.okhttp.OkHttpConstants;
import com.navercorp.pinpoint.plugin.okhttp.v3.RouteGetter;
import okhttp3.Address;
import okhttp3.Route;

public class RealConnectionConnectMethodInterceptor
extends SpanEventSimpleAroundInterceptorForPlugin {
    public RealConnectionConnectMethodInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        super(traceContext, descriptor);
    }

    protected void doInBeforeTrace(SpanEventRecorder recorder, Object target, Object[] args) {
    }

    protected void doInAfterTrace(SpanEventRecorder recorder, Object target, Object[] args, Object result, Throwable throwable) {
        Route route;
        recorder.recordApi(this.methodDescriptor);
        recorder.recordServiceType(OkHttpConstants.OK_HTTP_CLIENT_INTERNAL);
        recorder.recordException(throwable);
        if (target instanceof RouteGetter && (route = ((RouteGetter)target)._$PINPOINT$_getRoute()) != null) {
            String hostAndPort = this.getHostAndPort(route);
            recorder.recordAttribute(AnnotationKey.HTTP_INTERNAL_DISPLAY, hostAndPort);
        }
    }

    private String getHostAndPort(Route route) {
        Address address = route.address();
        return HostAndPort.toHostAndPortString((String)address.url().host(), (int)address.url().port());
    }
}

