/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.vertx.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.vertx.VertxConstants;

public class ContextImplExecuteBlockingInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private TraceContext traceContext;
    private MethodDescriptor descriptor;

    public ContextImplExecuteBlockingInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        this.traceContext = traceContext;
        this.descriptor = methodDescriptor;
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        if (!this.validate(args)) {
            return;
        }
        AsyncContextAccessorHandlers handlers = this.getAsyncContextAccessorHandlers(args);
        if (handlers.blockingCodeHandler != null || handlers.resultHandler != null) {
            AsyncContext asyncContext = recorder.recordNextAsyncContext();
            if (handlers.blockingCodeHandler != null) {
                handlers.blockingCodeHandler._$PINPOINT$_setAsyncContext(asyncContext);
                if (this.isDebug) {
                    this.logger.debug("Set asyncTraceId metadata for ContextImpl.executeBlocking blockingCodeHandler. asyncContext={}", (Object)asyncContext);
                }
            }
            if (handlers.resultHandler != null) {
                handlers.resultHandler._$PINPOINT$_setAsyncContext(asyncContext);
                if (this.isDebug) {
                    this.logger.debug("Set asyncTraceId metadata for ContextImpl.executeBlocking resultHandler. asyncContext={}", (Object)asyncContext);
                }
            }
        }
    }

    private boolean validate(Object[] args) {
        if (args == null || args.length < 2) {
            if (this.isDebug) {
                this.logger.debug("Invalid args object. args={}.", args);
            }
            return false;
        }
        return true;
    }

    private AsyncContextAccessorHandlers getAsyncContextAccessorHandlers(Object[] args) {
        AsyncContextAccessorHandlers handlers = new AsyncContextAccessorHandlers();
        if (args.length == 2) {
            if (args[1] instanceof AsyncContextAccessor) {
                handlers.resultHandler = (AsyncContextAccessor)args[1];
                return handlers;
            }
        } else if (args.length == 3) {
            if (args[0] instanceof AsyncContextAccessor) {
                handlers.blockingCodeHandler = (AsyncContextAccessor)args[0];
            }
            if (args[2] instanceof AsyncContextAccessor) {
                handlers.resultHandler = (AsyncContextAccessor)args[2];
            }
        }
        return handlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args, result, throwable);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            recorder.recordApi(this.descriptor);
            recorder.recordServiceType(VertxConstants.VERTX_INTERNAL);
            recorder.recordException(throwable);
        }
        finally {
            trace.traceBlockEnd();
        }
    }

    private static class AsyncContextAccessorHandlers {
        private AsyncContextAccessor blockingCodeHandler;
        private AsyncContextAccessor resultHandler;

        private AsyncContextAccessorHandlers() {
        }
    }
}

