/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.id;

import com.google.inject.Inject;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.profiler.context.id.DefaultTraceRoot;
import com.navercorp.pinpoint.profiler.context.id.TraceIdFactory;
import com.navercorp.pinpoint.profiler.context.id.TraceRoot;
import com.navercorp.pinpoint.profiler.context.id.TraceRootFactory;
import com.navercorp.pinpoint.profiler.context.module.AgentId;

public class DefaultTraceRootFactory
implements TraceRootFactory {
    private final String agentId;
    private final TraceIdFactory traceIdFactory;

    @Inject
    public DefaultTraceRootFactory(@AgentId String agentId, TraceIdFactory traceIdFactory) {
        if (agentId == null) {
            throw new NullPointerException("agentId");
        }
        if (traceIdFactory == null) {
            throw new NullPointerException("traceIdFactory");
        }
        this.agentId = agentId;
        this.traceIdFactory = traceIdFactory;
    }

    @Override
    public TraceRoot newTraceRoot(long transactionId) {
        TraceId traceId = this.traceIdFactory.newTraceId(transactionId);
        long startTime = this.traceStartTime();
        return new DefaultTraceRoot(traceId, this.agentId, startTime, transactionId);
    }

    private long traceStartTime() {
        return System.currentTimeMillis();
    }

    @Override
    public TraceRoot continueTraceRoot(TraceId traceId, long transactionId) {
        if (traceId == null) {
            throw new NullPointerException("traceId must not be null");
        }
        long startTime = this.traceStartTime();
        return new DefaultTraceRoot(traceId, this.agentId, startTime, transactionId);
    }
}

