/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.httpclient4.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.config.HttpDumpConfig;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.pair.NameIntValuePair;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientHeaderAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestWrapper;
import com.navercorp.pinpoint.bootstrap.plugin.request.ClientRequestWrapperAdaptor;
import com.navercorp.pinpoint.bootstrap.plugin.request.DefaultRequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.RequestTraceWriter;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieExtractor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.CookieRecorderFactory;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.EntityExtractor;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.EntityRecorder;
import com.navercorp.pinpoint.bootstrap.plugin.request.util.EntityRecorderFactory;
import com.navercorp.pinpoint.common.plugin.util.HostAndPort;
import com.navercorp.pinpoint.plugin.httpclient4.HttpClient4Constants;
import com.navercorp.pinpoint.plugin.httpclient4.HttpClient4CookieExtractor;
import com.navercorp.pinpoint.plugin.httpclient4.HttpClient4EntityExtractor;
import com.navercorp.pinpoint.plugin.httpclient4.HttpClient4PluginConfig;
import com.navercorp.pinpoint.plugin.httpclient4.HttpClient4RequestWrapper;
import com.navercorp.pinpoint.plugin.httpclient4.HttpRequest4ClientHeaderAdaptor;
import com.navercorp.pinpoint.plugin.httpclient4.RequestProducerGetter;
import com.navercorp.pinpoint.plugin.httpclient4.ResultFutureGetter;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

public class DefaultClientExchangeHandlerImplStartMethodInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();
    private final TraceContext traceContext;
    private final MethodDescriptor methodDescriptor;
    private final ClientRequestRecorder<ClientRequestWrapper> clientRequestRecorder;
    private final CookieRecorder<HttpRequest> cookieRecorder;
    private final EntityRecorder<HttpRequest> entityRecorder;
    private final RequestTraceWriter<HttpRequest> requestTraceWriter;

    public DefaultClientExchangeHandlerImplStartMethodInterceptor(TraceContext traceContext, MethodDescriptor methodDescriptor) {
        this.traceContext = traceContext;
        this.methodDescriptor = methodDescriptor;
        HttpClient4PluginConfig config = new HttpClient4PluginConfig(traceContext.getProfilerConfig());
        boolean param = config.isParam();
        HttpDumpConfig httpDumpConfig = config.getHttpDumpConfig();
        ClientRequestAdaptor clientRequestAdaptor = ClientRequestWrapperAdaptor.INSTANCE;
        this.clientRequestRecorder = new ClientRequestRecorder(param, clientRequestAdaptor);
        CookieExtractor<HttpRequest> cookieExtractor = HttpClient4CookieExtractor.INSTANCE;
        this.cookieRecorder = CookieRecorderFactory.newCookieRecorder((HttpDumpConfig)httpDumpConfig, cookieExtractor);
        EntityExtractor<HttpRequest> entityExtractor = HttpClient4EntityExtractor.INSTANCE;
        this.entityRecorder = EntityRecorderFactory.newEntityRecorder((HttpDumpConfig)httpDumpConfig, entityExtractor);
        HttpRequest4ClientHeaderAdaptor clientHeaderAdaptor = new HttpRequest4ClientHeaderAdaptor();
        this.requestTraceWriter = new DefaultRequestTraceWriter((ClientHeaderAdaptor)clientHeaderAdaptor, traceContext);
    }

    public void before(Object target, Object[] args) {
        Trace trace;
        if (this.isDebug) {
            this.logger.beforeInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentRawTraceObject()) == null) {
            return;
        }
        HttpRequest httpRequest = this.getHttpRequest(target);
        NameIntValuePair<String> host = this.getHost(target);
        boolean sampling = trace.canSampled();
        if (!sampling) {
            if (httpRequest != null) {
                this.requestTraceWriter.write((Object)httpRequest);
            }
            return;
        }
        SpanEventRecorder recorder = trace.traceBlockBegin();
        TraceId nextId = trace.getTraceId().getNextTraceId();
        recorder.recordNextSpanId(nextId.getSpanId());
        recorder.recordServiceType(HttpClient4Constants.HTTP_CLIENT_4);
        if (httpRequest != null) {
            String hostString = this.getHostString((String)host.getName(), host.getValue());
            this.requestTraceWriter.write((Object)httpRequest, nextId, hostString);
        }
        try {
            if (this.isAsynchronousInvocation(target, args)) {
                AsyncContext asyncContext = recorder.recordNextAsyncContext();
                ((AsyncContextAccessor)((ResultFutureGetter)target)._$PINPOINT$_getResultFuture())._$PINPOINT$_setAsyncContext(asyncContext);
                if (this.isDebug) {
                    this.logger.debug("Set AsyncContext {}", (Object)asyncContext);
                }
            }
        }
        catch (Throwable t) {
            this.logger.warn("Failed to BEFORE process. {}", (Object)t.getMessage(), (Object)t);
        }
    }

    private String getHostString(String hostName, int port) {
        if (hostName != null) {
            return HostAndPort.toHostAndPortString((String)hostName, (int)port);
        }
        return null;
    }

    private HttpRequest getHttpRequest(Object target) {
        try {
            if (!(target instanceof RequestProducerGetter)) {
                return null;
            }
            HttpAsyncRequestProducer requestProducer = ((RequestProducerGetter)target)._$PINPOINT$_getRequestProducer();
            return requestProducer.generateRequest();
        }
        catch (Exception e) {
            return null;
        }
    }

    private NameIntValuePair<String> getHost(Object target) {
        HttpAsyncRequestProducer producer;
        HttpHost httpHost;
        if (target instanceof RequestProducerGetter && (httpHost = (producer = ((RequestProducerGetter)target)._$PINPOINT$_getRequestProducer()).getTarget()) != null) {
            return new NameIntValuePair((Object)httpHost.getHostName(), httpHost.getPort());
        }
        return new NameIntValuePair(null, -1);
    }

    private boolean isAsynchronousInvocation(Object target, Object[] args) {
        if (!(target instanceof ResultFutureGetter)) {
            this.logger.debug("Invalid target object. Need field accessor({}).", (Object)"resultFuture");
            return false;
        }
        BasicFuture future = ((ResultFutureGetter)target)._$PINPOINT$_getResultFuture();
        if (future == null) {
            this.logger.debug("Invalid target object. field is null({}).", (Object)"resultFuture");
            return false;
        }
        if (!(future instanceof AsyncContextAccessor)) {
            this.logger.debug("Invalid resultFuture field object. Need metadata accessor({}).", (Object)"asyncContext");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        Trace trace;
        if (this.isDebug) {
            this.logger.afterInterceptor(target, args);
        }
        if ((trace = this.traceContext.currentTraceObject()) == null) {
            return;
        }
        try {
            SpanEventRecorder recorder = trace.currentSpanEventRecorder();
            HttpRequest httpRequest = this.getHttpRequest(target);
            NameIntValuePair<String> host = this.getHost(target);
            if (httpRequest != null) {
                HttpClient4RequestWrapper clientRequest = new HttpClient4RequestWrapper(httpRequest, (String)host.getName(), host.getValue());
                this.clientRequestRecorder.record(recorder, (Object)clientRequest, throwable);
                this.cookieRecorder.record(recorder, (Object)httpRequest, throwable);
                this.entityRecorder.record(recorder, (Object)httpRequest, throwable);
            }
            recorder.recordApi(this.methodDescriptor);
            recorder.recordException(throwable);
        }
        finally {
            trace.traceBlockEnd();
        }
    }
}

