/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.objectfactory;

import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentContext;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentorDelegate;
import com.navercorp.pinpoint.bootstrap.interceptor.annotation.Name;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.InterceptorScope;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.objectfactory.ArgumentProvider;
import com.navercorp.pinpoint.profiler.objectfactory.Option;
import com.navercorp.pinpoint.profiler.util.TypeUtils;
import java.lang.annotation.Annotation;

public class ProfilerPluginArgumentProvider
implements ArgumentProvider {
    private final ProfilerConfig profilerConfig;
    private final TraceContext traceContext;
    private final InstrumentContext pluginContext;

    public ProfilerPluginArgumentProvider(ProfilerConfig profilerConfig, TraceContext traceContext, InstrumentContext pluginContext) {
        if (profilerConfig == null) {
            throw new NullPointerException("profilerConfig must not be null");
        }
        if (traceContext == null) {
            throw new NullPointerException("traceContext must not be null");
        }
        if (pluginContext == null) {
            throw new NullPointerException("pluginContext must not be null");
        }
        this.profilerConfig = profilerConfig;
        this.traceContext = traceContext;
        this.pluginContext = pluginContext;
    }

    @Override
    public Option get(int index, Class<?> type, Annotation[] annotations) {
        if (type == Trace.class) {
            return Option.withValue(this.traceContext.currentTraceObject());
        }
        if (type == TraceContext.class) {
            return Option.withValue(this.traceContext);
        }
        if (type == Instrumentor.class) {
            InstrumentorDelegate delegate = new InstrumentorDelegate(this.profilerConfig, this.pluginContext);
            return Option.withValue(delegate);
        }
        if (type == InterceptorScope.class) {
            Name annotation = TypeUtils.findAnnotation(annotations, Name.class);
            if (annotation == null) {
                return Option.empty();
            }
            InterceptorScope scope = this.pluginContext.getInterceptorScope(annotation.value());
            if (scope == null) {
                throw new PinpointException("No such Scope: " + annotation.value());
            }
            return Option.withValue(scope);
        }
        return Option.empty();
    }
}

