/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context;

import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceId;
import com.navercorp.pinpoint.common.annotations.InterfaceAudience;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.exception.PinpointException;
import com.navercorp.pinpoint.profiler.context.BaseTraceFactory;
import com.navercorp.pinpoint.profiler.context.Binder;
import com.navercorp.pinpoint.profiler.context.Reference;
import com.navercorp.pinpoint.profiler.context.TraceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTraceFactory
implements TraceFactory {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Binder<Trace> threadLocalBinder;
    private final BaseTraceFactory baseTraceFactory;

    public DefaultTraceFactory(BaseTraceFactory baseTraceFactory, Binder<Trace> binder) {
        this.baseTraceFactory = (BaseTraceFactory)Assert.requireNonNull((Object)baseTraceFactory, (String)"baseTraceFactory must not be null");
        this.threadLocalBinder = (Binder)Assert.requireNonNull(binder, (String)"binder must not be null");
    }

    @Override
    public Trace currentTraceObject() {
        Reference<Trace> reference = this.threadLocalBinder.get();
        Trace trace = reference.get();
        if (trace == null) {
            return null;
        }
        if (trace.canSampled()) {
            return trace;
        }
        return null;
    }

    @Override
    public Trace currentRawTraceObject() {
        Reference<Trace> reference = this.threadLocalBinder.get();
        return reference.get();
    }

    @Override
    public Trace disableSampling() {
        Reference<Trace> reference = this.checkAndGet();
        Trace trace = this.baseTraceFactory.disableSampling();
        this.bind(reference, trace);
        return trace;
    }

    @Override
    public Trace continueTraceObject(TraceId traceId) {
        Reference<Trace> reference = this.checkAndGet();
        Trace trace = this.baseTraceFactory.continueTraceObject(traceId);
        this.bind(reference, trace);
        return trace;
    }

    @Override
    public Trace continueTraceObject(Trace trace) {
        Reference<Trace> reference = this.checkAndGet();
        this.bind(reference, trace);
        return trace;
    }

    private Reference<Trace> checkAndGet() {
        Reference<Trace> reference = this.threadLocalBinder.get();
        Trace old = reference.get();
        if (old != null) {
            PinpointException exception = new PinpointException("already Trace Object exist.");
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("beforeTrace:{}", (Object)old, (Object)exception);
            }
            throw exception;
        }
        return reference;
    }

    @Override
    public Trace newTraceObject() {
        Reference<Trace> reference = this.checkAndGet();
        Trace trace = this.baseTraceFactory.newTraceObject();
        this.bind(reference, trace);
        return trace;
    }

    private void bind(Reference<Trace> reference, Trace trace) {
        reference.set(trace);
    }

    @Override
    public Trace removeTraceObject() {
        Reference<Trace> reference = this.threadLocalBinder.get();
        Trace trace = reference.clear();
        return trace;
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace continueAsyncTraceObject(TraceId traceId) {
        Reference<Trace> reference = this.checkAndGet();
        Trace trace = this.baseTraceFactory.continueAsyncTraceObject(traceId);
        this.bind(reference, trace);
        return trace;
    }

    @Override
    @InterfaceAudience.LimitedPrivate(value={"vert.x"})
    public Trace newAsyncTraceObject() {
        Reference<Trace> reference = this.checkAndGet();
        Trace trace = this.baseTraceFactory.newAsyncTraceObject();
        this.bind(reference, trace);
        return trace;
    }
}

