/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.thrift.io;

import com.navercorp.pinpoint.io.header.ByteArrayHeaderWriter;
import com.navercorp.pinpoint.io.header.Header;
import com.navercorp.pinpoint.io.header.HeaderEntity;
import com.navercorp.pinpoint.io.header.InvalidHeaderException;
import com.navercorp.pinpoint.io.util.TypeLocator;
import com.navercorp.pinpoint.thrift.io.ResettableByteArrayOutputStream;
import com.navercorp.pinpoint.thrift.io.TBaseSerializer;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TIOStreamTransport;
import org.apache.thrift.transport.TTransport;

public class HeaderTBaseSerializer
implements TBaseSerializer {
    private static final String UTF8 = "UTF8";
    private final ResettableByteArrayOutputStream baos;
    private final TProtocol protocol;
    private final TypeLocator<TBase<?, ?>> locator;

    HeaderTBaseSerializer(ResettableByteArrayOutputStream bos, TProtocolFactory protocolFactory, TypeLocator<TBase<?, ?>> locator) {
        this.baos = bos;
        TIOStreamTransport transport = new TIOStreamTransport((OutputStream)bos);
        this.protocol = protocolFactory.getProtocol((TTransport)transport);
        this.locator = locator;
    }

    @Override
    public byte[] serialize(TBase<?, ?> base) throws TException {
        return this.serialize(base, HeaderEntity.EMPTY_HEADER_ENTITY);
    }

    @Override
    public byte[] serialize(TBase<?, ?> base, HeaderEntity headerEntity) throws TException {
        this.baos.reset();
        this.writeHeader(base, headerEntity);
        base.write(this.protocol);
        return this.baos.toByteArray();
    }

    private void writeHeader(TBase<?, ?> base) {
        this.writeHeader(base, HeaderEntity.EMPTY_HEADER_ENTITY);
    }

    private void writeHeader(TBase<?, ?> base, HeaderEntity headerEntity) {
        try {
            Header header = this.locator.headerLookup(base);
            if (header == null) {
                throw new TException("header must not be null base:" + base);
            }
            ByteArrayHeaderWriter headerWriter = new ByteArrayHeaderWriter(header, headerEntity);
            byte[] headerBytes = headerWriter.writeHeader();
            this.baos.write(headerBytes);
        }
        catch (Exception e) {
            throw new InvalidHeaderException("can not write header.", e);
        }
    }

    public byte[] continueSerialize(TBase<?, ?> base) throws TException {
        this.writeHeader(base);
        base.write(this.protocol);
        return this.baos.toByteArray();
    }

    public void reset() {
        this.baos.reset();
    }

    public void reset(int resetIndex) {
        this.baos.reset(resetIndex);
    }

    public int getInterBufferSize() {
        return this.baos.size();
    }

    public String toString(TBase<?, ?> base) throws TException {
        return this.toString(base, UTF8);
    }

    public String toString(TBase<?, ?> base, String charset) throws TException {
        try {
            return new String(this.serialize(base), charset);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT ENCODING: " + charset);
        }
    }
}

