/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.jdbc.cubrid;

import com.navercorp.pinpoint.bootstrap.instrument.InstrumentClass;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentException;
import com.navercorp.pinpoint.bootstrap.instrument.InstrumentMethod;
import com.navercorp.pinpoint.bootstrap.instrument.Instrumentor;
import com.navercorp.pinpoint.bootstrap.instrument.MethodFilter;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformCallback;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplate;
import com.navercorp.pinpoint.bootstrap.instrument.transformer.TransformTemplateAware;
import com.navercorp.pinpoint.bootstrap.interceptor.scope.ExecutionPolicy;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPlugin;
import com.navercorp.pinpoint.bootstrap.plugin.ProfilerPluginSetupContext;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.JdbcUrlParserV2;
import com.navercorp.pinpoint.bootstrap.plugin.jdbc.PreparedStatementBindingMethodFilter;
import com.navercorp.pinpoint.bootstrap.plugin.util.InstrumentUtils;
import com.navercorp.pinpoint.common.util.VarArgs;
import com.navercorp.pinpoint.plugin.jdbc.cubrid.CubridConfig;
import com.navercorp.pinpoint.plugin.jdbc.cubrid.CubridConstants;
import com.navercorp.pinpoint.plugin.jdbc.cubrid.CubridJdbcUrlParser;
import java.security.ProtectionDomain;
import java.util.List;

public class CubridPlugin
implements ProfilerPlugin,
TransformTemplateAware {
    private static final String CUBRID_SCOPE = "CUBRID_SCOPE";
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private TransformTemplate transformTemplate;
    private final JdbcUrlParserV2 jdbcUrlParser = new CubridJdbcUrlParser();

    public void setup(ProfilerPluginSetupContext context) {
        CubridConfig config = new CubridConfig(context.getConfig());
        if (!config.isPluginEnable()) {
            this.logger.info("Cubrid plugin is not executed because plugin enable value is false.");
            return;
        }
        context.addJdbcUrlParser(this.jdbcUrlParser);
        this.addCUBRIDConnectionTransformer(config);
        this.addCUBRIDDriverTransformer();
        this.addCUBRIDPreparedStatementTransformer(config);
        this.addCUBRIDCallableStatementTransformer();
        this.addCUBRIDStatementTransformer();
    }

    private void addCUBRIDConnectionTransformer(final CubridConfig config) {
        this.transformTemplate.transform("cubrid.jdbc.driver.CUBRIDConnection", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"close", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.ConnectionCloseInterceptor", CubridPlugin.CUBRID_SCOPE);
                String statementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"createStatement", (String[])new String[]{"int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementCreateInterceptor", CubridPlugin.CUBRID_SCOPE);
                String preparedStatementCreate = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int[]"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "java.lang.String[]"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareStatement", (String[])new String[]{"java.lang.String", "int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"prepareCall", (String[])new String[]{"java.lang.String", "int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementCreateInterceptor", CubridPlugin.CUBRID_SCOPE);
                if (config.isProfileSetAutoCommit()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"setAutoCommit", (String[])new String[]{"boolean"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionSetAutoCommitInterceptor", CubridPlugin.CUBRID_SCOPE);
                }
                if (config.isProfileCommit()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"commit", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionCommitInterceptor", CubridPlugin.CUBRID_SCOPE);
                }
                if (config.isProfileRollback()) {
                    InstrumentUtils.findMethod((InstrumentClass)target, (String)"rollback", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.TransactionRollbackInterceptor", CubridPlugin.CUBRID_SCOPE);
                }
                return target.toBytecode();
            }
        });
    }

    private void addCUBRIDDriverTransformer() {
        this.transformTemplate.transform("cubrid.jdbc.driver.CUBRIDDriver", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"connect", (String[])new String[]{"java.lang.String", "java.util.Properties"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.DriverConnectInterceptorV2", VarArgs.va((Object[])new Object[]{CubridConstants.CUBRID}), CubridPlugin.CUBRID_SCOPE, ExecutionPolicy.ALWAYS);
                return target.toBytecode();
            }
        });
    }

    private void addCUBRIDPreparedStatementTransformer(final CubridConfig config) {
        this.transformTemplate.transform("cubrid.jdbc.driver.CUBRIDPreparedStatement", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor");
                int maxBindValueSize = config.getMaxSqlBindValueSize();
                String preparedStatementInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[0]).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementExecuteQueryInterceptor", VarArgs.va((Object[])new Object[]{maxBindValueSize}), CubridPlugin.CUBRID_SCOPE);
                if (config.isTraceSqlBindValue()) {
                    PreparedStatementBindingMethodFilter filter = new PreparedStatementBindingMethodFilter();
                    List declaredMethods = target.getDeclaredMethods((MethodFilter)filter);
                    for (InstrumentMethod method : declaredMethods) {
                        method.addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.PreparedStatementBindVariableInterceptor", CubridPlugin.CUBRID_SCOPE);
                    }
                }
                return target.toBytecode();
            }
        });
    }

    private void addCUBRIDCallableStatementTransformer() {
        this.transformTemplate.transform("cubrid.jdbc.driver.CUBRIDCallableStatement", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.ParsingResultAccessor");
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.BindValueAccessor");
                String callableStatementInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor", CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor", CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"registerOutParameter", (String[])new String[]{"int", "int", "java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.CallableStatementRegisterOutParameterInterceptor", CubridPlugin.CUBRID_SCOPE);
                return target.toBytecode();
            }
        });
    }

    private void addCUBRIDStatementTransformer() {
        this.transformTemplate.transform("cubrid.jdbc.driver.CUBRIDStatement", new TransformCallback(){

            public byte[] doInTransform(Instrumentor instrumentor, ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws InstrumentException {
                InstrumentClass target = instrumentor.getInstrumentClass(loader, className, classfileBuffer);
                target.addField("com.navercorp.pinpoint.bootstrap.plugin.jdbc.DatabaseInfoAccessor");
                String executeQueryInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteQueryInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeQuery", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteQueryInterceptor", CubridPlugin.CUBRID_SCOPE);
                String executeUpdateInterceptor = "com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor";
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"executeUpdate", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", CubridPlugin.CUBRID_SCOPE);
                InstrumentUtils.findMethod((InstrumentClass)target, (String)"execute", (String[])new String[]{"java.lang.String", "int"}).addScopedInterceptor("com.navercorp.pinpoint.bootstrap.plugin.jdbc.interceptor.StatementExecuteUpdateInterceptor", CubridPlugin.CUBRID_SCOPE);
                return target.toBytecode();
            }
        });
    }

    public void setTransformTemplate(TransformTemplate transformTemplate) {
        this.transformTemplate = transformTemplate;
    }
}

