/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.receiver.service;

import com.navercorp.pinpoint.common.util.Assert;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Queue;

class LimitedList<E>
implements Collection<E> {
    private final int maxSize;
    private Comparator<E> comparator;
    private final Queue<E> queue;

    public LimitedList(int maxSize, Comparator<E> comparator) {
        Assert.isTrue((maxSize > 0 ? 1 : 0) != 0, (String)"maxSize must not be negative");
        this.comparator = (Comparator)Assert.requireNonNull(comparator, (String)"comparator must not be null");
        this.maxSize = maxSize;
        this.queue = new PriorityQueue<E>(maxSize, comparator);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.queue.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.queue.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.queue.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.queue.retainAll(c);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean add(E e) {
        if (this.queue.size() >= this.maxSize) {
            E minSnapshot = this.queue.peek();
            if (this.comparator.compare(minSnapshot, e) < 0) {
                this.queue.poll();
                return this.queue.offer(e);
            }
            return false;
        }
        return this.queue.add(e);
    }
}

