/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler.context.monitor;

import com.navercorp.pinpoint.bootstrap.plugin.monitor.DataSourceMonitor;
import com.navercorp.pinpoint.common.trace.ServiceType;
import com.navercorp.pinpoint.profiler.context.monitor.PluginMonitorWrapper;
import java.lang.ref.WeakReference;

public class DataSourceMonitorWrapper
implements PluginMonitorWrapper,
DataSourceMonitor {
    private final int id;
    private final WeakReference<DataSourceMonitor> monitorReference;
    private volatile ServiceType serviceType;

    public DataSourceMonitorWrapper(int id, DataSourceMonitor dataSourceMonitor) {
        if (dataSourceMonitor == null) {
            throw new NullPointerException("dataSourceMonitor must not be null");
        }
        this.id = id;
        this.monitorReference = new WeakReference<DataSourceMonitor>(dataSourceMonitor);
    }

    private DataSourceMonitor getInstance() {
        return (DataSourceMonitor)this.monitorReference.get();
    }

    @Override
    public int getId() {
        return this.id;
    }

    public ServiceType getServiceType() {
        ServiceType copy = this.serviceType;
        if (copy != null) {
            return copy;
        }
        DataSourceMonitor dataSourceMonitor = this.getInstance();
        if (dataSourceMonitor != null) {
            this.serviceType = this.getServiceType0(dataSourceMonitor);
            return this.serviceType;
        }
        return ServiceType.UNKNOWN;
    }

    public ServiceType getServiceType0(DataSourceMonitor dataSourceMonitor) {
        ServiceType serviceType = dataSourceMonitor.getServiceType();
        if (serviceType == null) {
            return ServiceType.UNKNOWN;
        }
        return serviceType;
    }

    public String getUrl() {
        DataSourceMonitor dataSourceMonitor = this.getInstance();
        if (dataSourceMonitor != null) {
            return dataSourceMonitor.getUrl();
        }
        return null;
    }

    public int getActiveConnectionSize() {
        DataSourceMonitor dataSourceMonitor = this.getInstance();
        if (dataSourceMonitor != null) {
            return dataSourceMonitor.getActiveConnectionSize();
        }
        return -1;
    }

    public int getMaxConnectionSize() {
        DataSourceMonitor dataSourceMonitor = this.getInstance();
        if (dataSourceMonitor != null) {
            return dataSourceMonitor.getMaxConnectionSize();
        }
        return -1;
    }

    public boolean isDisabled() {
        DataSourceMonitor dataSourceMonitor = this.getInstance();
        if (dataSourceMonitor == null) {
            return true;
        }
        return dataSourceMonitor.isDisabled();
    }

    @Override
    public boolean equalsWithUnwrap(Object object) {
        if (object == null) {
            return false;
        }
        DataSourceMonitor instance = this.getInstance();
        if (instance == null) {
            return false;
        }
        return instance == object;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DataSourceMonitorWrapper{");
        sb.append("id=").append(this.id);
        sb.append('}');
        return sb.toString();
    }
}

