/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.profiler;

import com.navercorp.pinpoint.bootstrap.Agent;
import com.navercorp.pinpoint.bootstrap.AgentOption;
import com.navercorp.pinpoint.bootstrap.config.ProfilerConfig;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerBinder;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.util.SocketAddressUtils;
import com.navercorp.pinpoint.common.util.Assert;
import com.navercorp.pinpoint.profiler.AgentStatus;
import com.navercorp.pinpoint.profiler.context.module.ApplicationContext;
import com.navercorp.pinpoint.profiler.context.module.DefaultApplicationContext;
import com.navercorp.pinpoint.profiler.context.module.DefaultModuleFactoryResolver;
import com.navercorp.pinpoint.profiler.context.module.ModuleFactory;
import com.navercorp.pinpoint.profiler.logging.Slf4jLoggerBinder;
import com.navercorp.pinpoint.profiler.util.SystemPropertyDumper;
import com.navercorp.pinpoint.rpc.ClassPreLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAgent
implements Agent {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PLoggerBinder binder;
    private final ProfilerConfig profilerConfig;
    private final ApplicationContext applicationContext;
    private final Object agentStatusLock = new Object();
    private volatile AgentStatus agentStatus;

    public DefaultAgent(AgentOption agentOption) {
        if (agentOption == null) {
            throw new NullPointerException("agentOption must not be null");
        }
        if (agentOption.getInstrumentation() == null) {
            throw new NullPointerException("instrumentation must not be null");
        }
        if (agentOption.getProfilerConfig() == null) {
            throw new NullPointerException("profilerConfig must not be null");
        }
        this.logger.info("AgentOption:{}", (Object)agentOption);
        this.binder = new Slf4jLoggerBinder();
        this.bindPLoggerFactory(this.binder);
        this.dumpSystemProperties();
        this.dumpConfig(agentOption.getProfilerConfig());
        this.changeStatus(AgentStatus.INITIALIZING);
        this.preloadOnStartup();
        this.profilerConfig = agentOption.getProfilerConfig();
        this.applicationContext = this.newApplicationContext(agentOption);
    }

    protected ApplicationContext newApplicationContext(AgentOption agentOption) {
        Assert.requireNonNull((Object)agentOption, (String)"agentOption must not be null");
        ProfilerConfig profilerConfig = (ProfilerConfig)Assert.requireNonNull((Object)agentOption.getProfilerConfig(), (String)"profilerConfig must not be null");
        DefaultModuleFactoryResolver moduleFactoryResolver = new DefaultModuleFactoryResolver(profilerConfig.getInjectionModuleFactoryClazzName());
        ModuleFactory moduleFactory = moduleFactoryResolver.resolve();
        return new DefaultApplicationContext(agentOption, moduleFactory);
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    private void dumpSystemProperties() {
        SystemPropertyDumper dumper = new SystemPropertyDumper();
        dumper.dump();
    }

    private void dumpConfig(ProfilerConfig profilerConfig) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{}\n{}", (Object)"dumpConfig", (Object)profilerConfig);
        }
    }

    private void changeStatus(AgentStatus status) {
        this.agentStatus = status;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Agent status is changed. {}", (Object)status);
        }
    }

    private void bindPLoggerFactory(PLoggerBinder binder) {
        String binderClassName = binder.getClass().getName();
        PLogger pLogger = binder.getLogger(binder.getClass().getName());
        pLogger.info("PLoggerFactory.initialize() bind:{} cl:{}", (Object)binderClassName, (Object)binder.getClass().getClassLoader());
        PLoggerFactory.initialize((PLoggerBinder)binder);
    }

    private void preloadOnStartup() {
        SocketAddressUtils.getHostNameFirst(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.agentStatusLock;
        synchronized (object) {
            if (this.agentStatus != AgentStatus.INITIALIZING) {
                this.logger.warn("Agent already started.");
                return;
            }
            this.changeStatus(AgentStatus.RUNNING);
        }
        this.logger.info("Starting {} Agent.", (Object)"pinpoint");
        this.applicationContext.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.agentStatusLock;
        synchronized (object) {
            if (this.agentStatus != AgentStatus.RUNNING) {
                this.logger.warn("Cannot stop agent. Current status = [{}]", (Object)this.agentStatus);
                return;
            }
            this.changeStatus(AgentStatus.STOPPED);
        }
        this.logger.info("Stopping {} Agent.", (Object)"pinpoint");
        this.applicationContext.close();
        if (this.profilerConfig.getStaticResourceCleanup()) {
            PLoggerFactory.unregister((PLoggerBinder)this.binder);
        }
    }

    static {
        ClassPreLoader.preload();
    }
}

