/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.plugin.openwhisk.interceptor;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessorUtils;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.context.MethodDescriptor;
import com.navercorp.pinpoint.bootstrap.context.SpanEventRecorder;
import com.navercorp.pinpoint.bootstrap.context.Trace;
import com.navercorp.pinpoint.bootstrap.context.TraceContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.plugin.openwhisk.OpenwhiskConfig;
import com.navercorp.pinpoint.plugin.openwhisk.OpenwhiskConstants;
import com.navercorp.pinpoint.plugin.openwhisk.accessor.PinpointTraceAccessor;
import com.navercorp.pinpoint.plugin.openwhisk.descriptor.LogMarkerMethodDescriptor;
import scala.runtime.AbstractFunction0;
import whisk.common.LogMarkerToken;

public class TransactionIdStartedInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final TraceContext traceContext;
    private final MethodDescriptor descriptor;
    protected final boolean isDebug = this.logger.isDebugEnabled();
    private final boolean isLoggingMessage;

    public TransactionIdStartedInterceptor(TraceContext traceContext, MethodDescriptor descriptor) {
        this.traceContext = traceContext;
        this.descriptor = descriptor;
        OpenwhiskConfig config = new OpenwhiskConfig(traceContext.getProfilerConfig());
        this.isLoggingMessage = config.isLoggingMessage();
    }

    public void before(Object target, Object[] args) {
        block5: {
            AsyncContext asyncContext;
            if (this.isDebug) {
                this.logger.beforeInterceptor(target, args);
            }
            if ((asyncContext = AsyncContextAccessorUtils.getAsyncContext((Object)args[0])) == null) {
                this.logger.debug("Not found asynchronous invocation metadata {}", (Object)((LogMarkerToken)args[2]));
                return;
            }
            Trace trace = asyncContext.continueAsyncTraceObject();
            if (trace == null) {
                this.logger.debug("trace object null");
            }
            try {
                trace.traceBlockBegin();
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block5;
                this.logger.warn("BEFORE. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        block11: {
            Trace trace;
            AsyncContext asyncContext;
            if (this.isDebug) {
                this.logger.afterInterceptor(target, args, result, throwable);
            }
            if ((asyncContext = AsyncContextAccessorUtils.getAsyncContext((Object)args[0])) == null) {
                this.logger.debug("Not found asynchronous invocation metadata");
                return;
            }
            if (this.isDebug) {
                this.logger.debug("Asynchronous invocation. asyncContext={}", (Object)asyncContext);
            }
            if ((trace = asyncContext.currentAsyncTraceObject()) == null) {
                return;
            }
            if (this.isDebug) {
                this.logger.debug("Asynchronous invocation. asyncTraceId={}, trace={}", (Object)asyncContext, (Object)trace);
            }
            this.traceContext.removeTraceObject();
            try {
                SpanEventRecorder recorder = trace.currentSpanEventRecorder();
                LogMarkerToken logMarkerToken = (LogMarkerToken)args[2];
                String message = ((AbstractFunction0)args[3]).apply().toString();
                recorder.recordApi((MethodDescriptor)new LogMarkerMethodDescriptor(logMarkerToken));
                if (logMarkerToken.component().equals("database")) {
                    recorder.recordServiceType(OpenwhiskConstants.COUCHDB_EXECUTE_QUERY);
                    recorder.recordDestinationId("COUCHDB");
                    recorder.recordAttribute(OpenwhiskConstants.MARKER_MESSAGE, message);
                } else {
                    recorder.recordServiceType(OpenwhiskConstants.OPENWHISK_INTERNAL);
                    if (this.isLoggingMessage && message.length() > 0) {
                        recorder.recordAttribute(OpenwhiskConstants.MARKER_MESSAGE, message);
                    }
                }
                if (result instanceof AsyncContextAccessor) {
                    ((AsyncContextAccessor)result)._$PINPOINT$_setAsyncContext(asyncContext);
                    ((PinpointTraceAccessor)result)._$PINPOINT$_setPinpointTrace(trace);
                }
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block11;
                this.logger.warn("AFTER error. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }
}

