/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.interceptor;

import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.interceptor.ExceptionHandler;

public class ExceptionHandleAroundInterceptor
implements AroundInterceptor {
    private final AroundInterceptor delegate;
    private final ExceptionHandler exceptionHandler;

    public ExceptionHandleAroundInterceptor(AroundInterceptor delegate, ExceptionHandler exceptionHandler) {
        if (delegate == null) {
            throw new NullPointerException("delegate must not be null");
        }
        if (exceptionHandler == null) {
            throw new NullPointerException("exceptionHandler must not be null");
        }
        this.delegate = delegate;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void before(Object target, Object[] args) {
        try {
            this.delegate.before(target, args);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleException(t);
        }
    }

    @Override
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        try {
            this.delegate.after(target, args, result, throwable);
        }
        catch (Throwable t) {
            this.exceptionHandler.handleException(t);
        }
    }
}

