#!/bin/bash
module_name=project
package_path="`pwd`/${module_name}/app.jar"
config_path="`pwd`/${module_name}/application.properties"
log_path="/home/quant_group/logs"

export NAMESPACE=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`
echo "NAMESPACE is $NAMESPACE"

if [[ $CLUSTER == "3B" ]]; then	
	echo "java -Xmx512m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Denv=pro -Didc=k8s3b -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} > /dev/null 2>&1" > java_command
	nohup java -Xmx512m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Denv=pro -Didc=k8s3b -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} > /dev/null 2>&1 &
	
	# waiting for log
	count=0
	log_exist=0

	until [[ $count -eq 60 ]] || [[ $log_exist -eq 1 ]]
	do
	  let count+=1
	  echo "waiting for log in $log_path ... $count"
  
	  if find "$log_path" -mindepth 1 -print -quit | grep -q .; then
	      echo "log is exist!"
		  log_exist=1
	  fi
	  sleep 1
	done
	
	# 安装filebeat
	PULL_TAR=http://git.q-gp.com/QA/qg-docker-entrypoints/raw/master/other/filebeat/filebeat.tgz
	TAR_PACKAGE=filebeat.tgz
	LOGS_PATH="\/home\/quant_group\/logs\/*.log"
	HOST_NAME=`cat /home/quant_group/build_info | grep 'SYSTEM_NAME' | awk -F: '{print $2}'`
	HOME_PATH="/home/quant_group"

	cd ${HOME_PATH} && curl -O ${PULL_TAR} && tar zxf ${TAR_PACKAGE} -C ${HOME_PATH} && rm -f ${TAR_PACKAGE}
	eval "sed -i 's/logs_path/${LOGS_PATH}/' ${HOME_PATH}/filebeat/filebeat.yml"
	eval "sed -i 's/host_name/${HOST_NAME}/g' ${HOME_PATH}/filebeat/filebeat.yml"
	chown -R root:root ${HOME_PATH}/filebeat/
	cd ${HOME_PATH}/filebeat/ && nohup ./filebeat filebeat.yml &
	
	if [[ $count -eq 60 ]] && [[ $log_exist -eq 0 ]]; then
		touch $log_path/error.log
		echo "Log is not exist or java server start error." >> ./logs/error.log 
	fi

    # 安装 crontab TODO apt or yum
    yum install -y crontabs
    
    # 定时删除日志
    deleteLogs()
    {
        daysRetained='10'
        sysName=`cat /home/quant_group/build_info | grep 'SYSTEM_NAME' | awk -F: '{print $2}'`
        sysName='xyqb-user2'
        crontabCmd="0 1 * * * find "$log_path" -mtime +"$daysRetained" -name '"$sysName".log.*' -exec rm -rf {} \;"
        tmpCronFile='/tmp/crontab.bak'
        crontab -l &> $tmpCronFile
        cat $tmpCronFile | grep -v "no crontab" &> $tmpCronFile
        currentCrontab=`cat $tmpCronFile`
        if [[ $currentCrontab == *"$crontabCmd"* ]]
        then
            echo 'task already existed!'
        else
            echo "$crontabCmd" >> $tmpCronFile
            crontab $tmpCronFile
            echo "add task to crontab!"
            rm $tmpCronFile
        fi
    }
    deleteLogs

    # must be end
    echo "tail -f $log_path/*log"
	tail -f $log_path/*log
else
	echo "clean ${log_path}/*"
		
	#历史遗留问题，抽空fix
	echo "replaceGitRemote"
	replaceGitRemote(){
		originDomain="192.168.3.60"
		activeDomain="git.q-gp.com"
	
		gdir=/home/qg-xterm
	    cd $gdir && echo '进入' $gdir
	    git rev-parse --is-inside-work-tree 2>&1 1>/dev/null; # 有个不行
 
	    if [ $? -ne 0 ]
	    then
	       echo "不是git目录 $gdir" $?;
	       cd ..
	       continue
	    fi
 
	    remoteUrl=`git config --get remote.origin.url`
	    echo $remoteUrl | grep $originDomain
 
	    if [ $? -eq 0 ]
	      then
	        remoteGit="${remoteUrl/$originDomain/$activeDomain}"
	        echo '替换后的' $remoteGit
	        git remote set-url origin $remoteGit || echo "修改失败" #状态
	    fi
	    cd -
	}
	replaceGitRemote
	rm -rf ${log_path}/*

    echo "kill java process"
    kill -9 $(ps -ef |grep '/home/quant_group/project/app.jar' | grep -v 'grep' | awk '{ print $2 }')
	
	echo 192.168.6.13 eos.quantgroups.com >> /etc/hosts
	echo 192.168.4.117 apollo-dev.quantgroups.com >> /etc/hosts
	echo 172.20.3.11 sentry.quantgroups.com >> /etc/hosts
	echo 192.168.4.3 sonar.quantgroups.com >> /etc/hosts
	echo 192.168.4.3 git.q-gp.com >> /etc/hosts
	echo 192.168.4.117 yapi.quantgroups.com >> /etc/hosts

	echo "sed domain from xyqb.com to liangkebang.com"
	sed -i "s#.xyqb.com#-$NAMESPACE.liangkebang.com#g" ${config_path}
	sed -i "s#.domain.com#-$NAMESPACE.liangkebang.com#g" ${config_path}
	#sed -i "s#.quantgroup.cn#-$NAMESPACE.liangkebang.com#g" ${config_path}
	sed -i "s#xterm.js demo#${SYSTEM_NAME}@${NAMESPACE}#"  /home/qg-xterm/demo/index.html
	
	echo "java -Xmx2048m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Denv=dev -Didc=k8s -Dtest=true -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} & " > java_command
	nohup java -Xmx2048m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=5005 -Denv=dev -Didc=k8s -Dtest=true -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} > /dev/null 2>&1 &
	
	# waiting for log
	count=0
	log_exist=0

	until [[ $count -eq 60 ]] || [[ $log_exist -eq 1 ]]
	do
	  let count+=1
	  echo "waiting for log in $log_path ... $count"
  
	  if find "$log_path" -mindepth 1 -print -quit | grep -q .; then
	      echo "log is exist!"
		  log_exist=1
	  fi
	  sleep 1
	done

	if [[ $count -eq 60 ]] && [[ $log_exist -eq 0 ]]; then
		touch ./logs/error.log
		echo "Log is not exist or java server start error." >> ./logs/error.log 
	fi
	
	echo "alias log='cd logs;tail -500f *log';" >> ~/.bashrc
	source ~/.bashrc
	source ~/.bash_profile
	
	echo "cd /home/qg-xterm/;git pull;cd -"
	cd /home/qg-xterm/;git pull;cd -
	
	# start recorder
	recorder_dir='/home/qg-recorder'
	if [ -d "$recorder_dir" ]; then
		echo "start recorder"
		cd /home/qg-recorder
		git pull
		sh start_recorder.sh
		cd -
	fi
	
	echo "node /home/qg-xterm/demo/app.js"
	nohup node /home/qg-xterm/demo/app.js &

	echo "frontail ./logs/*log -n 500 -d "
	frontail ./logs/*log -n 500 -d
	
	echo "tail -f ./logs/*"
	tail -f ./logs/*
fi
