#!/bin/bash

echo "start run java"

current="/home/quant_group"
echo "current: ${current}"
echo "NAMESPACE is $NAMESPACE"

module_name=project
module_path="${current}/${module_name}"
package_path="${module_path}/app.jar"
config_path="${module_path}/application.properties"
log_path="/home/quant_group/logs"

rm -rf ${log_path}/*

echo 172.30.220.17 eos.quantgroups.com >> /etc/hosts
echo 172.17.1.7 apollo-dev.quantgroups.com >> /etc/hosts
echo 172.20.3.11 sentry.quantgroups.com >> /etc/hosts

# echo 172.30.3.206 apollo-dev.quantgroups.com >> /etc/hosts
# echo 172.20.3.11 sentry.quantgroups.com >> /etc/hosts
# echo 192.168.4.3 sonar.quantgroups.com >> /etc/hosts
# echo 192.168.4.117 yapi.quantgroups.com >> /etc/hosts

echo "sed domain from xyqb.com to liangkebang.net"
sed -i "s#.xyqb.com#-$NAMESPACE.liangkebang.net#g" ${config_path}
sed -i "s#.domain.com#-$NAMESPACE.liangkebang.net#g" ${config_path}
# sed -i "s#.quantgroup.cn#-$NAMESPACE.liangkebang.net#g" ${config_path}
# sed -i "s#xterm.js demo#${SYSTEM_NAME}@${NAMESPACE}#"  /home/qg-xterm/demo/index.html

namespace="$NAMESPACE"
echo "namespace is $namespace"
echo "unset NAMESPACE" >>  ~/.bashrc
echo "alias log='cd logs;tail -500f *log';" >> ~/.bashrc
source ~/.bashrc
# source ~/.bash_profile

basicCmd="java -Xmx512m -XX:CompressedClassSpaceSize=128m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Dtest=true"
debugCmd="-agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=5005"
apolloCmd="-Denv=dev -Didc=k8s -DNAMESPACE=${namespace} -Dapollo.longPollingInitialDelayInMills=200000"
apolloMockCmd="-Denv=dev -Didc=k8s-mock -DNAMESPACE=${namespace} -Dapollo.longPollingInitialDelayInMills=200000"
# -jar选项需要在调试和apollo选项后面
jarCmd="-jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80"
logCmd="-Dlogging.config=classpath:logback-dev.xml"

finalCmd=""
if [[ $SYSTEM_NAME == 'gu-bei' ]]; then
  finalCmd="$basicCmd $debugCmd $apolloMockCmd $jarCmd --spring.config.location=${config_path}"
elif [[ $SYSTEM_NAME == 'pcm' || $SYSTEM_NAME == 'acs-batch' || $SYSTEM_NAME == 'acs-quartz' || $SYSTEM_NAME == 'acs-service' || $SYSTEM_NAME == 'acs-web' || $SYSTEM_NAME == 'app-server' ]]; then
  # 不能指定config.location
  finalCmd="$basicCmd $debugCmd $apolloCmd $jarCmd"
# elif [[ $SYSTEM_NAME == 'xyqb-mall' ]]; then
#   # xyqb-mall打印调试信息
#   finalCmd="$basicCmd $debugCmd $logCmd $apolloCmd $jarCmd --spring.config.location=${config_path}"
else
  finalCmd="$basicCmd $debugCmd $apolloCmd $jarCmd --spring.config.location=${config_path}"
fi

echo "$finalCmd" > java_command

if [[ $DEBUG == 1 ]]; then
  echo 'debug'
  nohup $finalCmd &
  tail -f ~/.bashrc
else
  nohup $finalCmd 
fi

echo done!