#!/bin/bash

echo "start run java"
current="/home/quant_group"
echo "current: ${current}"
echo "NAMESPACE is $NAMESPACE"

module_name=project
module_path="${current}/${module_name}"
package_path="${module_path}/app.jar"
config_path="${module_path}/application.properties"
log_path="/home/quant_group/logs"

echo 192.168.4.50 eos.quantgroups.com >> /etc/hosts
if [[ $CLUSTER == 'qke' ]]; then
  echo 172.30.3.209 apollo-dev.quantgroups.com >> /etc/hosts
else
  echo 172.17.1.7 apollo-dev.quantgroups.com >> /etc/hosts
fi
echo 172.20.3.11 sentry.quantgroups.com >> /etc/hosts

# dubboPort=`curl -s -m 5 curl 'http://qaapi.liangkebang.com/k8s/service/details' -H 'cluster: qa' -H 'content-type: application/json;charset=UTF-8'  --data-binary "{\"serviceName\":\"${SYSTEM_NAME}\",\"namespace\":\"${NAMESPACE}\",\"type\":\"java\",\"key\":\"port_20880\"}"`
get_dubbo_port = "http://holmes.liangkebang.com/k8s/dubbo/port?namespace=${NAMESPACE}&serviceType=java&serviceName=${SYSTEM_NAME}&key=port_20880"
echo "获取dubboPort url: $get_dubbo_port"
dubboPort=`curl -s -m 5 "$get_dubbo_port"`
echo "获取到的dubboPort为: $dubboPort"
if [[ ${#dubboPort} == 5 ]];then
  echo dubboPort
  echo $dubboPort
  export DUBBO_PORT_TO_REGISTRY=$dubboPort
  echo "export DUBBO_PORT_TO_REGISTRY=$dubboPort" >>  ~/.bashrc
fi

#OLD_IFS="$IFS"
#IFS="&"
#array=($HOSTS)
#IFS="$OLD_IFS"
#
#for var in ${array[@]}
#do
#   echo $var|sed "s#=># #g" >> /etc/hosts
#done

# echo 172.30.3.206 apollo-dev.quantgroups.com >> /etc/hosts
# echo 172.20.3.11 sentry.quantgroups.com >> /etc/hosts
# echo 192.168.4.3 sonar.quantgroups.com >> /etc/hosts
# echo 192.168.4.117 yapi.quantgroups.com >> /etc/hosts

echo "sed domain from xyqb.com to liangkebang.net"
sed -i "s#.xyqb.com#-$NAMESPACE.liangkebang.net#g" ${config_path}
sed -i "s#.domain.com#-$NAMESPACE.liangkebang.net#g" ${config_path}
# sed -i "s#.quantgroup.cn#-$NAMESPACE.liangkebang.net#g" ${config_path}
# sed -i "s#xterm.js demo#${SYSTEM_NAME}@${NAMESPACE}#"  /home/qg-xterm/demo/index.html

namespace="$NAMESPACE"
cluster="$CLUSTER"
echo "namespace is $namespace"
echo "cluster is $cluster"
echo "unset NAMESPACE" >>  ~/.bashrc
echo "alias log='cd logs;tail -500f *log';" >> ~/.bashrc
source ~/.bashrc

# startCmd=`curl -s -m 5 "http://qaapi.liangkebang.com/proconfig/get_info?system_name=${SYSTEM_NAME}&key=start_command"`
# if [[ "$startCmd" == ""  ||  "$startCmd" =~ '0001' ]]; then 
#     echo "获取start_command异常，请检查 http://qaapi.liangkebang.com/proconfig/get_info?system_name=${SYSTEM_NAME}&key=start_command" 
#     exit -1
# fi
startCmd=`curl -s -m 5 "http://holmes.liangkebang.com/docker/project/get_info?projectName=${SYSTEM_NAME}&key=start_command"`
if [[ "$startCmd" == "" ]]; then 
    echo "获取start_command异常，请检查 http://holmes.liangkebang.com/docker/project/get_info?projectName=${SYSTEM_NAME}&key=start_command" 
    exit -1
fi

if [[ $CLUSTER == 'qke' ]]; then
    finalCmd=`echo $startCmd | sed "s#place-holder#${NAMESPACECLUSTER}#g"`
else
    finalCmd=`echo $startCmd | sed "s#place-holder#${namespace}#g"`
fi

if [[ $MOCK == 1 ]];then
    finalCmd=`echo $finalCmd | sed 's#k8s#k8s-mock#g'`
fi

echo "$finalCmd"
echo "$finalCmd" > java_command

# 日志挂载到了/home/logs下
# 创建新目录，并把/home/quant_group/logs指向新目录
logdir="/home/logs/${HOSTNAME}"
mkdir -p "${logdir}"
echo "创建日志目录：$logdir"

rm -rf "logs"
ln -s "${logdir}" "${log_path}"

if [[ $DEBUG == 1 ]]; then
  echo 'debug mode'
  nohup $finalCmd &
  tail -f ~/.bashrc
else
  nohup $finalCmd
fi

echo done!
