#!/bin/sh
echo "deploy xyqp-query"
package_path="/home/quant_group/project"

echo "replaceGitRemote"
echo 192.168.4.3 git.q-gp.com >> /etc/hosts

replaceGitRemote(){
	originDomain="192.168.3.60"
	activeDomain="git.q-gp.com"

	gdir=/home/qg-xterm
    cd $gdir && echo '进入' $gdir
    git rev-parse --is-inside-work-tree 2>&1 1>/dev/null; # 有个不行

    if [ $? -ne 0 ]
    then
       echo "不是git目录 $gdir" $?;
       cd ..
       continue
    fi

    remoteUrl=`git config --get remote.origin.url`
    echo $remoteUrl | grep $originDomain

    if [ $? -eq 0 ]
      then
        remoteGit="${remoteUrl/$originDomain/$activeDomain}"
        echo '替换后的' $remoteGit
        git remote set-url origin $remoteGit || echo "修改失败" #状态
    fi
    cd -
}
replaceGitRemote

echo "cd ${package_path}"
cd ${package_path}
source ~/.bash_profile

echo "tar zxf dist.tgz  -C ${package_path}"
tar zxf ${package_path}/dist.tgz  -C ${package_path}/

echo "rm dist.tgz public/dist -rf"
rm -rf ${package_path}/dist.tgz

echo "python run.py --mode=beta --port=80"
python ${package_path}/server/run.py --mode=beta --port=80