#!/bin/sh

echo "start run golang"

package_path="/home/quant_group/project"
echo "NAMESPACE is $NAMESPACE"
echo "cd ${package_path}"
cd ${package_path}

echo "echo host"
echo 192.168.4.50 eos.quantgroups.com >> /etc/hosts

# qke直连apollo服务
if [[ $CLUSTER == 'qke' ]]; then
  echo 172.30.3.208 apollo-dev.quantgroups.com >> /etc/hosts
else
  echo 172.17.1.7 apollo-dev.quantgroups.com >> /etc/hosts
fi
# end

# 日志挂载到了/home/logs下
# 创建新目录，并把/home/quant_group/logs指向新目录
logdir="/home/logs/${HOSTNAME}"
mkdir -p "${logdir}"
echo "创建日志目录：$logdir"

rm -rf "logs"
ln -s "${logdir}" "${package_path}/logs"

echo "start"

./main
if [[ $DEBUG == 1 ]]; then
  echo 'debug'
  tail -f ~/.vimrc
fi

echo done!!!
