#!/bin/bash

echo "start run ui"

current="/home/quant_group"
echo "current: ${current}"

export NAMESPACE=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`
echo "NAMESPACE is $NAMESPACE"

# 运行qa工具
echo "SYSTEM_NAME is $SYSTEM_NAME"
host=`curl -s -m 5 "http://172.17.1.7:3003/proconfig/get_info?system_name=${SYSTEM_NAME}&key=host_name"`
if [ -z "$host" ]; then 
    echo "host is empty，请检查服务 http://172.17.1.7:3003" 
    exit -1
fi

echo "host: ${host}"

for entry in ./*tgz
do
    with_ext=$(basename "$entry")
    echo ${with_ext}
    fname="${with_ext%.*}"
    
    echo "mkdir -p ${current}/$fname"
    mkdir -p ${current}/$fname
    
    echo "tar zxf ${current}/$with_ext -C ${current}/$fname"
    tar zxf ${current}/$with_ext -C ${current}/$fname
    
    # echo "rm -rf ${package_path}/$with_ext"
    # rm -rf ${package_path}/$with_ext
done

curl -sSL http://git.quantgroup.cn/QA/config_repository/raw/master/yaml/replace.py -o replace.py
curl -sSL http://git.quantgroup.cn/QA/config_repository/raw/master/yaml/replace_config_tke.yaml -o replace_config.yaml
python replace.py $host;

echo "/usr/bin/openresty -g 'daemon off;'"
/usr/bin/openresty -g 'daemon off;'