#!/bin/bash
module_name=project
package_path="`pwd`/${module_name}/app.jar"
config_path="`pwd`/${module_name}/application.properties"
log_path="/home/quant_group/logs"
export NAMESPACE=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`
echo "NAMESPACE is $NAMESPACE"

echo 192.168.3.2 ldap.quantgroups.com >> /etc/hosts
echo 192.168.6.13 eos.quantgroups.com >> /etc/hosts
echo 192.168.4.117 apollo-dev.quantgroups.com >> /etc/hosts

echo "sed domain from xyqb.com to q-gp.com"
sed -i "s#.xyqb.com#-$NAMESPACE.q-gp.com#g" ${config_path}
sed -i "s#.domain.com#-$NAMESPACE.q-gp.com#g" ${config_path}
sed -i "s#.quantgroup.cn#-$NAMESPACE.q-gp.com#g" ${config_path}
sed -i "s#xterm.js demo#${SYSTEM_NAME}@${NAMESPACE}#"  /home/qg-xterm/demo/index.html

echo "clean ${log_path}/*"
rm -rf ${log_path}/*

echo "kill java process"
kill -9 $(ps -ef |grep '/home/quant_group/project/app.jar' | grep -v 'grep' | awk '{ print $2 }')

if [[ $CLUSTER == "3B" ]]; then	
	echo "java -Xmx512m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Denv=pro -Didc=k8s3b -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} >/dev/null 2>&1" > java_command
	nohup java -Xmx512m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Denv=pro -Didc=k8s3b -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} >/dev/null 2>&1 &
	
	# waiting for log
	count=0
	log_exist=0

	until [[ $count -eq 60 ]] || [[ $log_exist -eq 1 ]]
	do
	  let count+=1
	  echo "waiting for log in $log_path ... $count"
  
	  if find "$log_path" -mindepth 1 -print -quit | grep -q .; then
	      echo "log is exist!"
		  log_exist=1
	  fi
	  sleep 1
	done
	
	PULL_TAR=http://192.168.3.60/QA/qg-docker-entrypoints/raw/master/other/filebeat/filebeat.tgz
	TAR_PACKAGE=filebeat.tgz
	LOGS_PATH="\/home\/quant_group\/logs\/*.log"
	HOST_NAME=`cat /home/quant_group/build_info | grep 'SYSTEM_NAME' | awk -F: '{print $2}'`
	HOME_PATH="/home/quant_group"

	cd ${HOME_PATH} && curl -O ${PULL_TAR} && tar zxf ${TAR_PACKAGE} -C ${HOME_PATH}
	eval "sed -i 's/logs_path/${LOGS_PATH}/' ${HOME_PATH}/filebeat/filebeat.yml"
	eval "sed -i 's/host_name/${HOST_NAME}/g' ${HOME_PATH}/filebeat/filebeat.yml"
	chown -R root:root ${HOME_PATH}/filebeat/
	cd ${HOME_PATH}/filebeat/ && nohup ./filebeat filebeat.yml &
	
	if [[ $count -eq 60 ]] && [[ $log_exist -eq 0 ]]; then
		touch ./logs/error.log
		echo "Log is not exist or java server start error." >> ./logs/error.log 
	fi
	
	echo "tail -f ./logs/*log"
	tail -f ./logs/*log
else
	echo "java -Xmx512m  -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Denv=dev -Didc=k8s -Dtest=true -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} & " > java_command
	nohup java -Xmx512m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=5005 -Denv=dev -Didc=k8s -Dtest=true -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} >/dev/null 2>&1 &
	
	# waiting for log
	count=0
	log_exist=0

	until [[ $count -eq 60 ]] || [[ $log_exist -eq 1 ]]
	do
	  let count+=1
	  echo "waiting for log in $log_path ... $count"
  
	  if find "$log_path" -mindepth 1 -print -quit | grep -q .; then
	      echo "log is exist!"
		  log_exist=1
	  fi
	  sleep 1
	done

	if [[ $count -eq 60 ]] && [[ $log_exist -eq 0 ]]; then
		touch ./logs/error.log
		echo "Log is not exist or java server start error." >> ./logs/error.log 
	fi
	
	source ~/.bash_profile
	
	echo "cd /home/qg-xterm/;git pull;cd -"
	cd /home/qg-xterm/;git pull;cd -

	echo "node /home/qg-xterm/demo/app.js"
	nohup node /home/qg-xterm/demo/app.js &

	echo "frontail ./logs/*log -n 500 -d "
	frontail ./logs/*log -n 500 -d
	
	echo "tail -f ./logs/*log"
	tail -f ./logs/*log
fi