#!/bin/bash

echo "start run java"

current="/home/quant_group"
echo "current: ${current}"
echo "NAMESPACE is $NAMESPACE"

module_name=project
module_path="${current}/${module_name}"
package_path="${module_path}/app.jar"
config_path="${module_path}/application.properties"
log_path="/home/quant_group/logs"

rm -rf ${log_path}/*

# echo "kill java process"
# kill -9 $(ps -ef |grep '/home/quant_group/project/app.jar' | grep -v 'grep' | awk '{ print $2 }')

echo 172.17.1.7 eos.quantgroups.com >> /etc/hosts
echo 192.168.4.117 apollo-dev.quantgroups.com >> /etc/hosts
# echo 172.30.3.206 apollo-dev.quantgroups.com >> /etc/hosts
echo 172.20.3.11 sentry.quantgroups.com >> /etc/hosts
echo 192.168.4.3 sonar.quantgroups.com >> /etc/hosts
echo 192.168.4.3 git.q-gp.com >> /etc/hosts
echo 192.168.4.117 yapi.quantgroups.com >> /etc/hosts

echo "sed domain from xyqb.com to liangkebang.net"
sed -i "s#.xyqb.com#-$NAMESPACE.liangkebang.net#g" ${config_path}
sed -i "s#.domain.com#-$NAMESPACE.liangkebang.net#g" ${config_path}
# sed -i "s#.quantgroup.cn#-$NAMESPACE.liangkebang.net#g" ${config_path}
# sed -i "s#xterm.js demo#${SYSTEM_NAME}@${NAMESPACE}#"  /home/qg-xterm/demo/index.html

echo "java -Xmx512m  -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -Denv=dev -Didc=k8s -Dtest=true -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} & " > java_command
nohup java -Xmx512m -Xloggc:/tmp/${module_name}_gc.log -XX:+PrintGCDetails -XX:+PrintGCTimeStamps -agentlib:jdwp=transport=dt_socket,server=y,suspend=n,address=5005 -Denv=dev -Didc=k8s -Dtest=true -jar ${package_path} --worker 1 --currentWorker 1 -t --server.port=80 --spring.config.location=${config_path} 

# waiting for log
count=0
log_exist=0

until [[ $count -eq 60 ]] || [[ $log_exist -eq 1 ]]
do
  let count+=1
  echo "waiting for log in $log_path ... $count"

  if find "$log_path" -mindepth 1 -print -quit | grep -q .; then
    echo "log is exist!"
    log_exist=1
  fi
  sleep 1
done

if [[ $count -eq 60 ]] && [[ $log_exist -eq 0 ]]; then
  touch ./logs/error.log
  echo "Log is not exist or java server start error." >> ./logs/error.log 
fi

echo "alias log='cd logs;tail -500f *log';" >> ~/.bashrc
source ~/.bashrc
source ~/.bash_profile

# echo "frontail ./logs/*log -n 500 -d "
# frontail ./logs/*log -n 500 -d

echo done!