#!/bin/bash

echo "start run ui"

current="/home/quant_group"
echo "current: ${current}"

export NAMESPACE=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`
echo "NAMESPACE is $NAMESPACE"

# 运行qa工具
echo "SYSTEM_NAME is $SYSTEM_NAME"
host=`curl -s -m 5 "http://qaapi.liangkebang.com/proconfig/get_info?system_name=${SYSTEM_NAME}&key=host_name"`
echo "host: ${host}"
if [[ "$host" == ""  ||  "$host" =~ '0001' ]]; then 
    echo "获取host异常，请检查 http://qaapi.liangkebang.com/proconfig/get_info?system_name=${SYSTEM_NAME}&key=host_name" 
    exit -1
fi

for entry in ./*tgz
do
    with_ext=$(basename "$entry")
    echo ${with_ext}
    fname="${with_ext%.*}"
    
    echo "mkdir -p ${current}/$fname"
    mkdir -p ${current}/$fname
    
    echo "tar zxf ${current}/$with_ext -C ${current}/$fname"
    tar zxf ${current}/$with_ext -C ${current}/$fname
    
    # echo "rm -rf ${package_path}/$with_ext"
    # rm -rf ${package_path}/$with_ext
done

curl -sSL http://git.quantgroup.cn/QA/config_repository/raw/master/yaml/replace.py -o replace.py
curl -sSL http://git.quantgroup.cn/QA/config_repository/raw/master/yaml/replace_config_tke.yaml -o replace_config.yaml
python replace.py $host;

# 删除日志的软链
rm -rf /usr/local/openresty/nginx/logs/access.log
rm -rf /usr/local/openresty/nginx/logs/error.log

echo "/usr/bin/openresty -g 'daemon off;'"
/usr/bin/openresty -g 'daemon off;'