#!/bin/sh
echo "deploy node"
package_path="/home/quant_group/project"

echo "cd ${package_path}"
cd ${package_path}

echo "echo host"
echo 192.168.6.13 eos.quantgroups.com >> /etc/hosts
echo 192.168.4.3 git.q-gp.com >> /etc/hosts
echo 192.168.4.117 apollo-dev.quantgroups.com >> /etc/hosts
echo 172.20.3.11 sentry.quantgroups.com >> /etc/hosts
echo 192.168.4.3 npmprivate.quantgroups.com >> /etc/hosts

echo "replaceGitRemote"
replaceGitRemote(){
	originDomain="192.168.3.60"
	activeDomain="git.q-gp.com"

	gdir=/home/qg-xterm
    cd $gdir && echo '进入' $gdir
    git rev-parse --is-inside-work-tree 2>&1 1>/dev/null; # 有个不行

    if [ $? -ne 0 ]
    then
       echo "不是git目录 $gdir" $?;
       cd ..
       continue
    fi

    remoteUrl=`git config --get remote.origin.url`
    echo $remoteUrl | grep $originDomain

    if [ $? -eq 0 ]
      then
        remoteGit="${remoteUrl/$originDomain/$activeDomain}"
        echo '替换后的' $remoteGit
        git remote set-url origin $remoteGit || echo "修改失败" #状态
    fi
    cd -
}
replaceGitRemote

echo "tar zxf dist.tgz  -C ${package_path}"
tar zxf ${package_path}/dist.tgz  -C ${package_path}/

echo "sed sed xyqb.com to liangkebang.com"
namespace=`cat /var/run/secrets/kubernetes.io/serviceaccount/namespace`
echo "namespace is $namespace"

echo "sed domain.com to liangkebang.com"
find ${package_path}/ -type f -name "*.js" | xargs sed -i "s#.domain.com#-$namespace.liangkebang.com#g"

echo "sed xyqb.com to liangkebang.com"
find ${package_path}/ -name "*.js" | xargs sed -i "s#.xyqb.com#-$NAMESPACE.liangkebang.com#g"


echo "sed q-gp.com to liangkebang.com"
find ${package_path}/ -name "*.js" | xargs sed -i "s#.q-gp.com#-$NAMESPACE.liangkebang.com#g"

sed -i "s#xterm.js demo#${SYSTEM_NAME}@${namespace}#"  /home/qg-xterm/demo/index.html

echo "rm dist.tgz public/dist -rf"
rm -rf ${package_path}/dist.tgz
source ~/.bash_profile

echo "sh start.sh"
sh start.sh

echo "sleep 3"
sleep 3

if ls ./*log 1> /dev/null 2>&1; then
    echo "ls -l ./logs"
    ls -l ./logs    
else
    echo "files do not exist"
    touch ./logs/tmp.log
fi

echo "cd /home/qg-xterm/;git pull;cd -"
cd /home/qg-xterm/;git pull;cd -

echo "node /home/qg-xterm/demo/app.js"
nohup node /home/qg-xterm/demo/app.js &

echo "frontail logs/*.log -d -n 1000"
frontail ./logs/*log -n 1000