#!/bin/sh
echo "deploy xyqp-query"
package_path="/home/quant_group/project"

echo "replaceGitRemote"
echo 192.168.4.3 git.q-gp.com >> /etc/hosts

replaceGitRemote(){
	originDomain="192.168.3.60"
	activeDomain="git.q-gp.com"

	gdir=/home/qg-xterm
    cd $gdir && echo '进入' $gdir
    git rev-parse --is-inside-work-tree 2>&1 1>/dev/null; # 有个不行

    if [ $? -ne 0 ]
    then
       echo "不是git目录 $gdir" $?;
       cd ..
       continue
    fi

    remoteUrl=`git config --get remote.origin.url`
    echo $remoteUrl | grep $originDomain

    if [ $? -eq 0 ]
      then
        remoteGit="${remoteUrl/$originDomain/$activeDomain}"
        echo '替换后的' $remoteGit
        git remote set-url origin $remoteGit || echo "修改失败" #状态
    fi
    cd -
}
replaceGitRemote

echo "cd ${package_path}"
cd ${package_path}
source ~/.bash_profile

echo "tar zxf dist.tgz  -C ${package_path}"
tar zxf ${package_path}/dist.tgz  -C ${package_path}/

echo "rm dist.tgz public/dist -rf"
rm -rf ${package_path}/dist.tgz

echo "sed domain.com to liangkebang.com"
find ${package_path}/ -type f -name "*.conf" | xargs sed -i "s#\.domain\.com#-$NAMESPACE.liangkebang.com#g"
find ${package_path}/ -type f -name "*.conf" | xargs sed -i "s#\.xyqb\.com#-$NAMESPACE.liangkebang.com#g"

echo "cd /home/qg-xterm/;git pull;cd -"
cd /home/qg-xterm/;git pull;cd -

echo "node /home/qg-xterm/demo/app.js"
nohup node /home/qg-xterm/demo/app.js &

echo "sed port from 8999 to 80"
find ${package_path}/ -type f -name "*.py" | xargs sed -i "s#8999#80#g"

echo "prepare  ~/.pip/pip.conf"
mkdir -p ~/.pip/
touch ~/.pip/pip.conf
echo "[global]" >> ~/.pip/pip.conf
echo "index-url=https://pypi.tuna.tsinghua.edu.cn/simple" >> ~/.pip/pip.conf
echo "[install]" >> ~/.pip/pip.conf
echo "trusted-host=mirrors.aliyun.com" >> ~/.pip/pip.conf

echo "pip intall requirements"
pip install -r ${package_path}/requirements.txt

echo "python run.py --mode=beta --port=80"
# python ${package_path}/server/run.py --mode=beta --port=80
nohup python ${package_path}/startup.py --mode=beta --port=80 &

echo "frontail logs/*.log -d -n 1000"
frontail ./logs/*log -n 1000