/**随机生成一个卡号*/
function RandomCreateBankID(bankType) {
    let cardNo = "";
    for (let i = 0; i < 200; i++) {
        let sb = []
        if (bankType == 'ICBC' || bankType == 'CCB' || bankType == 'ABC' || bankType == 'PSBC' || bankType == 'BCOM' || bankType == 'GDB' || bankType == 'BOC') {
            sb = []
            for (let i = 0; i < 13; i++) {
                sb.push(parseInt(Math.random() * 10));
            }
            //alert("***"+sb+"***");

        } else {
            sb = []
            for (let i = 0; i < 10; i++) {
                sb.push(parseInt(Math.random() * 10));
            }
        }

        let sbs = sb.join("")
        switch (bankType) {
            case "CCB":
                cardNo = "621700" + sbs
                bankCode = "105";
                break;
            case "CMBC":
                cardNo = "621691" + sbs
                bankCode = "305";
                break;
            case "ABC":
                cardNo = "622827" + sbs
                bankCode = "103";
                break;
            case "BCOM":
                cardNo = "622262" + sbs
                bankCode = "301";
                break;
            case "CMB":
                cardNo = "621486" + sbs
                bankCode = "308";
                break;
            case "SPDB":
                cardNo = "622521" + sbs
                bankCode = "310";
                break;
            case "GDB":
                cardNo = "622568" + sbs
                bankCode = "306";
                break;
            case "HXB":
                cardNo = "622632" + sbs
                bankCode = "304";
                break;
            case "PAB":
                cardNo = "622298" + sbs
                bankCode = "783";
                break;
            case "CITIC":
                cardNo = "622696" + sbs
                bankCode = "302";
                break;
            case "ICBC":
                cardNo = "620058" + sbs
                bankCode = "102";
                break;
            case "BOC":
                cardNo = "620061" + sbs
                bankCode = "104";
                break;
            case "CIB":
                cardNo = "622908" + sbs
                bankCode = "309";
                break;
            case "CEB":
                cardNo = "622660" + sbs
                bankCode = "303";
                break;
            case "PSBC":
                cardNo = "621799" + sbs
                bankCode = "403";
                break;
            default:
                cardNo = "621700" + sbs
                bankCode = "105";
        }
        console.log(cardNo)

        if (luhmCheck(cardNo)) {
            return (cardNo);
        }

        //	return 0;
    }
}

//Luhm校验规则：16位银行卡号（19位通用）:

// 1.将未带校验位的 15（或18）位卡号从右依次编号 1 到 15（18），位于奇数位号上的数字乘以 2。
// 2.将奇位乘积的个十位全部相加，再加上所有偶数位上的数字。
// 3.将加法和加上校验位能被 10 整除。

function luhmCheck(bankno) {
    let lastNum = bankno.substr(bankno.length - 1, 1);//取出最后一位（与luhm进行比较）

    let first15Num = bankno.substr(0, bankno.length - 1);//前15或18位
    let newArr = new Array();
    for (let i = first15Num.length - 1; i > -1; i--) {    //前15或18位倒序存进数组
        newArr.push(first15Num.substr(i, 1));
    }
    let arrJiShu = new Array();  //奇数位*2的积 <9
    let arrJiShu2 = new Array(); //奇数位*2的积 >9

    let arrOuShu = new Array();  //偶数位数组
    for (let j = 0; j < newArr.length; j++) {
        if ((j + 1) % 2 == 1) {//奇数位
            if (parseInt(newArr[j]) * 2 < 9)
                arrJiShu.push(parseInt(newArr[j]) * 2);
            else
                arrJiShu2.push(parseInt(newArr[j]) * 2);
        }
        else //偶数位
            arrOuShu.push(newArr[j]);
    }

    let jishu_child1 = new Array();//奇数位*2 >9 的分割之后的数组个位数
    let jishu_child2 = new Array();//奇数位*2 >9 的分割之后的数组十位数
    for (let h = 0; h < arrJiShu2.length; h++) {
        jishu_child1.push(parseInt(arrJiShu2[h]) % 10);
        jishu_child2.push(parseInt(arrJiShu2[h]) / 10);
    }

    let sumJiShu = 0; //奇数位*2 < 9 的数组之和
    let sumOuShu = 0; //偶数位数组之和
    let sumJiShuChild1 = 0; //奇数位*2 >9 的分割之后的数组个位数之和
    let sumJiShuChild2 = 0; //奇数位*2 >9 的分割之后的数组十位数之和
    let sumTotal = 0;
    for (let m = 0; m < arrJiShu.length; m++) {
        sumJiShu = sumJiShu + parseInt(arrJiShu[m]);
    }

    for (let n = 0; n < arrOuShu.length; n++) {
        sumOuShu = sumOuShu + parseInt(arrOuShu[n]);
    }

    for (let p = 0; p < jishu_child1.length; p++) {
        sumJiShuChild1 = sumJiShuChild1 + parseInt(jishu_child1[p]);
        sumJiShuChild2 = sumJiShuChild2 + parseInt(jishu_child2[p]);
    }
    //计算总和
    sumTotal = parseInt(sumJiShu) + parseInt(sumOuShu) + parseInt(sumJiShuChild1) + parseInt(sumJiShuChild2);

    //计算Luhm值
    let k = parseInt(sumTotal) % 10 == 0 ? 10 : parseInt(sumTotal) % 10;
    let luhm = 10 - k;

    if (lastNum == luhm) {
        // $("#banknoInfo").html("Luhm验证通过");
        return true;
    }
    else {
        //   $("#banknoInfo").html("银行卡号必须符合Luhm校验");
        return false;
    }
}

function createBank() {
    let cnt = 1
    let bank = 'ICBC'
    let re = []

    let t = RandomCreateBankID(bank)
    return { bank: bank, bank_no: t }
}

exports.createBankID = async function () {
    await this.bindDefault
    let req = this.request.query
    let cnt = req.count
    cnt = cnt ? cnt : 1
    let bank = req.bank
    bank = bank ? bank.toUpperCase() : bank = 'CMBC'
    let re = []

    if (!isNaN(cnt)) {
        cnt = cnt < 0 ? cnt = 10 : cnt;
        cnt = cnt > 100 ? cnt = 100 : cnt;
        for (let ii = 0; ii < cnt; ii++) {
            let t = RandomCreateBankID(bank)
            console.log(111, t)
            re.push(t)
        }
    } else {
        this.body = { code: "0001", msg: "count不是数字" }
    }
    this.body = { code: "0000", bankID: re, bank: bank, count: re.length }

}

let areaCode = {
    '11': '北京市',
    '12': '天津市',
    '13': '河北省',
    '14': '山西省',
    '15': '内蒙古',
    '21': '辽宁省',
    '22': '吉林省',
    '23': '黑龙江省',
    '31': '上海市',
    '32': '江苏省',
    '33': '浙江省',
    '34': '安徽省',
    '35': '福建省',
    '36': '江西省',
    '37': '山东省',
    '41': '河南省',
    '42': '湖北省',
    '43': '湖南省',
    '44': '广东省',
    '45': '广西省',
    '46': '海南省',
    '50': '重庆市',
    '51': '四川省',
    '52': '贵州省',
    '53': '云南省',
    '54': '西藏自治区',
    '61': '陕西省',
    '62': '甘肃省',
    '63': '青海省',
    '64': '宁夏回族自治区',
    '65': '新疆'
}

function getProvinceID(province) {
    for (let i in areaCode) {
        if (areaCode[i].indexOf(province) != -1) {
            console.log(222, i, areaCode[i])
            return i
        }
    }
}

/**随机生成一个身份证*/
function RandomCreateID(province_id) {
    function _RandomCreateID() {
        let aid, ac = null, yyyy = 0, mm = 0, dd = 0, rnd = 0;
        let Code = ['11', '12', '13', '14', '15', '21', '22', '23', '31', '32', '33', '34', '35', '36', '37', '41', '42', '43', '44', '45', '46', '50', '51', '52', '53', '54', '61', '62', '63', '64', '65'];

        province_id = province_id === "" ? Code[fRandomBy(0, 31)] : province_id
        aid = "" + province_id + fRandomBy(0, 9) + fRandomBy(0, 9) + fRandomBy(0, 9) + fRandomBy(0, 9);

        //alert("aid:"+aid);
        yyyy = fRandomBy(1960, 1990), mm = fRandomBy(1, 12), dd = fRandomBy(1, 31);
        rnd = "" + fRandomBy(0, 9) + fRandomBy(0, 9) + fRandomBy(0, 9);
        //alert("id0:"+ mm +"id0:"+ dd );
        //直接用mm后值会变成true或false,因为第二种写法的问题。
        //if ( (mm == 2) && (dd > 28) )   if ( mm == 2 && dd > 28 )
        if ((mm == 2) && (dd > 28)) {
            dd = fRandomBy(1, 28);
        }
        else if (((mm == 4) || (mm == 6) || (mm == 9) || (mm == 11)) && (dd == 31)) {
            dd = dd - 1;
        }
        mm = (mm < 10) ? ("0" + mm) : mm;
        dd = (dd < 10) ? ("0" + dd) : dd;
        let re = "" + aid + yyyy + mm + dd + rnd
        return re
    }

    let ff = false;
    let ct = 0;
    while (!ff) {
        ct++;
        ff = getCheckID(_RandomCreateID());
        if (ct = 200) {
            return (ff);
        }
    }
    ct = 0;
    return (ff);
}

/**根据15位身份证或者18位身份证的前17位生成18位身份证号码*/
function getCheckID(_pid) {
    let arrVerifyCode = [1, 0, "X", 9, 8, 7, 6, 5, 4, 3, 2];
    let wi = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2];
    if (_pid.length != 15 && _pid.length != 17) return (false);
    let ai = (_pid.length == 17) ? _pid : _pid.substr(0, 6) + "19" + _pid.substr(6);
    if (!/^\d+$/.test(ai)) {
        alert(ai);
        return (false);
    }
    let yyyy = ai.substr(6, 4), mm = ai.substr(10, 2) - 1, dd = ai.substr(12, 2);
    let d = new Date(yyyy, mm, dd), year = d.getFullYear(), mon = d.getMonth(), day = d.getDate(), now = new Date();
    if (year != yyyy || mon != mm || day != dd || d > now || now.getFullYear() - year > 140) return (false);
    let ret = 0
    for (let i = 0; i < 17; i++) {
        ret += ai.charAt(i) * wi[i];
    }
    ai += arrVerifyCode[ret %= 11];
    return (ai);
}

/**根据身份证取 省份,生日，性别*/
function getInfo(pid) {
    let _id = ParseID(pid);
    if (isNaN(_id.substr(0, 17))) return 0;
    _id = String(_id), sex = _id.substr(16, 1) % 2 ? "男" : "女";
    prov = areaCode[_id.substr(0, 2)] || "无法确定";
    let birthday = (new Date(_id.substr(6, 4), _id.substr(10, 2) - 1, _id.substr(12, 2))).toLocaleDateString();
    // let name = getName()
    // let phone = getMoble()
    let bank_info = createBank()
    return { ID: pid, IDProvince: prov, birthday: birthday, sex, sex, bank: bank_info.bank, bankNo: bank_info.bank_no }
}

let get_person_from_acs = function () {
    //  老环境获取pod内容
    this.url = `http://acs.q-gp.com/faker/a_person`;
    this.method = "GET"
}

function requestPromise(option) {
    return new Promise(function (resolve, reject) {
        request(option, function (err, res, body) {
            if (err) {
                resolve({ code: "0001", err: err })
                // reject()
            } else {
                resolve(body)
            }
        })
    })
}

//生成随机手机号
function getMoble() {

    let prefixArray = new Array("130", "131", "132", "133", "135", "137", "138", "170", "187", "189");
    let i = parseInt(10 * Math.random());
    let prefix = prefixArray[i];

    for (let j = 0; j < 8; j++) {
        prefix = prefix + Math.floor(Math.random() * 10);
    }
    return prefix

    // let x = document.getElementsByName("mobile_tel");
    // for (let i = 0; i < x.length; i++) {
    //     let o = x[i];
    //     o.value = prefix;
    // }
}

// 生成随机姓名
function getName() {
    let familyNames = new Array(
        "赵", "钱", "孙", "李", "周", "吴", "郑", "王", "冯", "陈",
        "褚", "卫", "蒋", "沈", "韩", "杨", "朱", "秦", "尤", "许",
        "何", "吕", "施", "张", "孔", "曹", "严", "华", "金", "魏",
        "陶", "姜", "戚", "谢", "邹", "喻", "柏", "水", "窦", "章",
        "云", "苏", "潘", "葛", "奚", "范", "彭", "郎", "鲁", "韦",
        "昌", "马", "苗", "凤", "花", "方", "俞", "任", "袁", "柳",
        "酆", "鲍", "史", "唐", "费", "廉", "岑", "薛", "雷", "贺",
        "倪", "汤", "滕", "殷", "罗", "毕", "郝", "邬", "安", "常",
        "乐", "于", "时", "傅", "皮", "卞", "齐", "康", "伍", "余",
        "元", "卜", "顾", "孟", "平", "黄", "和", "穆", "萧", "尹",
        "欧阳", "太史", "端木", "上官", "司马", "东方", "独孤", "南宫", "万俟", "闻人", "夏侯", "诸葛", "尉迟",
        "公羊", "赫连", "澹台", "皇甫", "宗政", "濮阳", "公冶", "太叔", "申屠", "公孙", "慕容", "仲孙",
        "钟离", "长孙", "宇文", "司徒", "鲜于", "司空", "闾丘", "子车", "亓官", "司寇", "巫马", "公西",
        "颛孙", "壤驷", "公良", "漆雕", "乐正", "宰父", "谷梁", "拓跋", "夹谷", "轩辕", "令狐", "段干",
        "百里", "呼延", "东郭", "南门", "羊舌", "微生", "公户", "公玉", "公仪", "梁丘", "公仲", "公上",
        "公门", "公山", "公坚", "左丘", "公伯", "西门", "公祖", "第五", "公乘", "贯丘", "公皙", "南荣",
        "东里", "东宫", "仲长", "子书", "子桑", "即墨", "达奚", "褚师", "吴铭"

    );
    let givenNames = new Array(
        "子璇", "淼", "国栋", "夫子", "瑞堂", "甜", "敏", "尚", "国贤", "贺祥", "晨涛",
        "昊轩", "易轩", "益辰", "益帆", "益冉", "瑾春", "瑾昆", "春齐", "杨", "文昊",
        "东东", "雄霖", "浩晨", "熙涵", "溶溶", "冰枫", "欣欣", "宜豪", "欣慧", "建政",
        "美欣", "淑慧", "文轩", "文杰", "欣源", "忠林", "榕润", "欣汝", "慧嘉", "新建",
        "建林", "亦菲", "林", "冰洁", "佳欣", "涵涵", "禹辰", "淳美", "泽惠", "伟洋",
        "涵越", "润丽", "翔", "淑华", "晶莹", "凌晶", "苒溪", "雨涵", "嘉怡", "佳毅",
        "子辰", "佳琪", "紫轩", "瑞辰", "昕蕊", "萌", "明远", "欣宜", "泽远", "欣怡",
        "佳怡", "佳惠", "晨茜", "晨璐", "运昊", "汝鑫", "淑君", "晶滢", "润莎", "榕汕",
        "佳钰", "佳玉", "晓庆", "一鸣", "语晨", "添池", "添昊", "雨泽", "雅晗", "雅涵",
        "清妍", "诗悦", "嘉乐", "晨涵", "天赫", "玥傲", "佳昊", "天昊", "萌萌", "若萌"
    );


    let i = parseInt(10 * Math.random()) * 10 + parseInt(10 * Math.random());
    let familyName = familyNames[i];

    let j = parseInt(10 * Math.random()) * 10 + parseInt(10 * Math.random());
    let givenName = givenNames[i];

    let name = familyName + givenName;
    return name

}

/**生成一定范围的随机数*/
function fRandomBy(under, over) {
    switch (arguments.length) {
        case 1:
            return parseInt(Math.random() * under + 1);
        case 2:
            return parseInt(Math.random() * (over - under + 1) + under);
        default:
            return 0;
    }
}

/**判断输入的15位或者18位身份证号码是否合法*/
function ParseID(pId) {
    let arrVerifyCode = [1, 0, "x", 9, 8, 7, 6, 5, 4, 3, 2];
    let wi = [7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2];
    if (pId.length != 15 && pId.length != 18) return ("身份证号码只能是15位或18位!");
    let ai = (pId.length == 18) ? pId.substr(0, 17) : pId.substr(0, 6) + "19" + pId.substr(6);
    if (!/^\d+$/.test(ai)) return ("身份证除最后一位外，必须为数字！");
    let yyyy = ai.substr(6, 4), mm = ai.substr(10, 2) - 1, dd = ai.substr(12, 2);
    let d = new Date(yyyy, mm, dd), year = d.getFullYear(), mon = d.getMonth(), day = d.getDate(), now = new Date();
    if (year != yyyy || mon != mm || day != dd || d > now || now.getFullYear() - year > 140) return ("身份证出生年月日输入错误！");
    let ret = 0
    for (let i = 0; i < 17; i++) {
        ret += ai.charAt(i) * wi[i];
    }
    ai += arrVerifyCode[ret %= 11];
    return ((pId.length == 18 && pId.toLowerCase() != ai) ? "身份证输入错误，正确的为\n" + ai + "！" : ai);
}

exports.createID = async function () {
    await this.bindDefault
    let req = this.request.query
    let cnt = req.count
    cnt = cnt ? cnt : 1
    let province = req.province
    let province_id = province ? getProvinceID(province) : ''
    let re = []

    if (!isNaN(cnt)) {
        cnt = cnt < 0 ? cnt = 10 : cnt;
        cnt = cnt > 100 ? cnt = 100 : cnt;
        for (let ii = 0; ii < cnt; ii++) {
            let t = RandomCreateID(province_id)
            let js_info = getInfo(t)
            console.log(111, js_info)

            let java_info = await requestPromise(new get_person_from_acs());
            java_info = JSON.parse(java_info)
            console.log(222, java_info)

            let temp = {}
            for (let i in js_info) {
                temp[i] = js_info[i]
            }
            for (let i in java_info) {
                if (i != 'idCardNo') {
                    temp[i] = java_info[i]
                }
            }
            re.push(temp)
        }
    } else {
        this.body = { code: "0001", msg: "count不是数字" }
    }
    this.body = { code: "0000", detail: re, count: re.length }

}