"use strict";

process.env.DEBUG = process.env.DEBUG || '*';

const serverConfig = require('./server.json');
const makeConfig = require('../src/utils').makeConfig;
var os = require('os');
var ifaces = os.networkInterfaces();
let ip = "0.0.0.0";
function getIp() {
  Object.keys(ifaces).forEach(function (ifname) {
    var alias = 0;

    ifaces[ifname].forEach(function (iface) {
      if ('IPv4' !== iface.family || iface.internal !== false) {
        return;
      }
      if (alias >= 1) {

      } else {
        if (ifname == "eth0" || ifname == "en0") {
          ip = iface.address;
        }
      }
      ++alias;
    });
  });
}
getIp();

let vhost = {};
vhost[ip] = 'qa-home';
vhost['qa.q-gp.com'] = 'qa-home';



module.exports = makeConfig({
  vhost: vhost,

  router: {
    prefix: {
      test: '/test'
    }
  },

  constant: {
    cdn: '',
    domain: {
    },
    token: ""
  },
  mock: {
    prefix: '/__MOCK__/'
  },
  template: {
  },
  proxy: {
    timeout: 15000
  },

  site: {
    env: 'production',
    port: 3002,
    hostname: ip
  },

  path: {
    project: './app/',
    default_path: {
      'qa-home': '/home/index'
    },
    default_jump: {
      'qa-home': true
    }
  },

  mongo: {
    options: {
    },
    api: {
      'qa-home': `mongodb://172.30.220.20:27017/qaHome`
    }
  },

  xload: {
    path: 'files/',
    upload: {
      encoding: 'utf-8',
      maxFieldsSize: 2 * 1024 * 1024,
      maxFields: 1000,
      keepExtensions: true
    },
    download: {}
  },

  csrf: {
    module: []
  },

  session: {
  }
}, serverConfig)