'use strict';
// model名称，即表名
exports.model = 'dbconfig';

// 表结构
exports.schema = [{
    dbname: { type: String, unique: true, required: true, index: true },
    ip: { type: String, unique: false, required: true, index: false },
    port: { type: Number, unique: false, required: true, index: false },
    username: { type: String, unique: false, required: false, index: false },
    passwd: { type: String, unique: false, required: false, index: false },
    table_list: { type: String, unique: false, required: false, index: false },
    update_at: { type: Date, unique: false, required: false, index: false },
}, {
    autoIndex: false,
    versionKey: false
}];

exports.methods = {
    saveByName: async function (dbname, data) {
        let gp = await this.model("dbconfig").findOne({ "dbname": dbname });
        // console.log(gp)
        if (!!!gp) {
            console.log("新建的DB配置");
            return await this.save();
        } else {
            console.log("已经存在的DB配置")
            return { code: "0001", msg: "已经存在的DB无法新建，请进行更新操作" }
        }
    },
    updateById: async function (_id, db) {
        let gp = await this.model("dbconfig").findOne({ "dbname": db.dbname });
        console.log(gp)
        // console.log(JSON.stringify(gp.update_at).substring(1, gp.update_at.length + 1) === db.update_at)
        if (!!!gp) {
            // 不存在该db,直接更新
            return await this.model("dbconfig").update({ "_id": _id }, db);
        } else if (gp._id == _id) {
            // 当前记录
            //gp.update_at="2018-04-01T13:29:46.641Z" db.update_at=2018-04-01T13:29:46.641Z
            let update_at = "\"" + db.update_at + "\""
            console.log(111, gp.update_at)
            console.log(222, typeof gp.update_at)
            if (gp.update_at === null || JSON.stringify(gp.update_at) === update_at) {
                db.update_at = new Date().toLocaleString()
                return await this.model("dbconfig").update({ "_id": _id }, db);
            } else {
                return { code: "0001", msg: "停留时间太长导致时间戳不正确，请刷新后再试~" }
            }

        } else {
            // 重命名为已存在的db名称，错误
            console.log("该DB名称已经存在，无法更新为该名称~")
            return { code: "0001", msg: "该DB名称已经存在，无法更新为该名称~" }
        }
    },

    getDBConfig: async function (query, column, sort) {
        return await this.model("dbconfig").find(query, column).sort(sort)
    },

    delete: async function (_id) {
        return await this.model("dbconfig").remove({ "_id": _id });

    }
}