'use strict';

exports.model = 'IndexUrl';
exports.schema = [{
    url: { type: String, unique: true, required: true, index: false },
    type: { type: String, unique: false, required: true, index: false },
    type_name: { type: String, unique: false, required: false, index: false },
    icon: { type: Object, unique: false, required: false, index: false },

    remark: { type: String, unique: false, required: false, index: false },

}, {
    autoIndex: false,
    versionKey: false
}]

// 静态方法:http://mongoosejs.com/docs/guide.html#statics
exports.statics = {}

// http://mongoosejs.com/docs/guide.html#methods
exports.methods = {
    getIndexUrl: async function (query, sort) {
        return await this.model("IndexUrl").find(query).sort(sort)
    },
    delete: async function (_id) {
        return await this.model("IndexUrl").remove({ "_id": _id })
    },

    saveByUrl: async function (url, data) {
        let gp = await this.model("IndexUrl").findOne({ "url": url });

        if (gp === null) {
            console.log("新建的项目");
            return await this.save();
        } else {
            console.log("已经存在的url配置")
            return { code: "0001", msg: "已经存在的url无法新建，请进行更新操作" }
        }
    },

    updateById: async function (_id, query) {
        let gp = await this.model("IndexUrl").findOne({ "url": query.url });
        console.log(gp)
        if (gp === null) {
            console.log("新的url");
            return await this.model("IndexUrl").update({ "_id": _id }, query)
        } else if (_id == gp._id) {
            console.log("更新本条记录")
            return await this.model("IndexUrl").update({ "_id": _id }, query)
        } else {
            console.log("已经存在的url")
            return { code: "0001", msg: "该url地址已经存在，不能更新为该地址" }
        }
    },

    getType: async function (type_name) {
        let type = await this.model("IndexUrl").findOne({ "type_name": type_name }, { "type": 1, "_id": 0 });
        return type.type
    }
}