'use strict';
// var mongoose = require('mongoose');
// var Schema = mongoose.Schema;
// model名称，即表名
exports.model = 'ProConfig';

// 表结构
exports.schema = [{
    // group, isActive, projectType, port, projectName, gitPathHead, logName, configFile, command, nodeVersion, desc, auth, command2, java_target_path
    git_lab: { type: String, unique: false, required: true, index: false },
    port: { type: Number, unique: true, required: true, index: false },
    is_active: { type: Boolean, unique: false, required: true, index: false },
    type: { type: String, unique: false, required: true, index: false },
    git_path: { type: String, unique: true, required: true, index: true },
    git_path_group: { type: String, unique: false, required: true, index: false },
    project_name: { type: String, unique: false, required: true, index: false },

    host_name: { type: String, unique: false, required: false, index: false },
    log_path: { type: String, unique: false, required: false, index: false },
    config_path: { type: String, unique: false, required: false, index: false },
    des: { type: String, unique: false, required: false, index: false },
    auth: { type: String, unique: false, required: false, index: false },
    jar_path: { type: String, unique: false, required: false, index: false },
    command1: { type: String, unique: false, required: false, index: false },
    command2: { type: String, unique: false, required: false, index: false },
    command3: { type: String, unique: false, required: false, index: false },
    command4: { type: String, unique: false, required: false, index: false },
    command5: { type: String, unique: false, required: false, index: false },
    build_command: { type: String, unique: false, required: false, index: false },
    start_command: { type: String, unique: false, required: false, index: false },
    stop_command: { type: String, unique: false, required: false, index: false }
}, {
    autoIndex: false,
    versionKey: false
}];

// 静态方法:http://mongoosejs.com/docs/guide.html#statics
exports.statics = {}

// http://mongoosejs.com/docs/guide.html#methods
exports.methods = {
    saveByPath: async function (git_path, data) {
        let gp = await this.model("ProConfig").findOne({ "gi_path": git_path });
        console.log(gp)
        if (!!!gp) {
            console.log("新建的项目");
            return await this.save();
        } else {
            console.log("已经存在的项目")
            return { code: "0001", msg: "已经存在的项目无法新建，请进行更新操作" }
        }
    },
    updateById: async function (_id, query) {
        let gp = await this.model("ProConfig").findOne({ "gi_path": query.git_path });
        if (gp) {
            // console.log("新建的项目");
            return { code: "0001", msg: "该git地址已经存在，请进行新建操作" }
        } else {
            console.log("已经存在的项目")
            return await this.model("ProConfig").update({ "_id": _id }, query);
        }
    },
    getNewPort: async function () {
        let items = await this.model("ProConfig").find();
        let first = 7000;
        for (let item of items) {
            if (item.port > first) {
                first = item.port;
            }
        }
        return first;
    },
    getProjectByQuery: async function (query, sort) {
        return await this.model("ProConfig").find(query).sort(sort)
    },
    delete: async function (_id) {
        return await this.model("ProConfig").remove({ "_id": _id });

    }
}

// db.templateurlroutes.update({},{$set:{last_version:"",relace_version:"",relace_flg:1}},{ multi: true })