
request = require('request')
var cproc = require('child_process')
var execSync = cproc.execSync

var jenkinsapi = require('jenkins-api')
var jenkins_user_pwd = 'http://qahome:Quantgroup123@'
var jenkins = jenkinsapi.init(jenkins_user_pwd + "192.168.4.96:8080/")
// var jenkins = jenkinsapi.init("http://qahome:qahome@192.168.4.2:8080/")

var eos_host = 'eos.quantgroups.com'
let default_username = 'xyqb_query'
let default_passwd = 'Uiwb@o^fR&nHOa5t'


exports.save = async function () {
    await this.bindDefault();
    let req = this.request.body

    if (req.dbname === '' || req.ip == '' || req.port == '') {
        this.body = {
            code: "0001", msg: "有必填项没有填写", data: {
                dbname: req.dbname,
                ip: req.ip,
                port: req.port,
                username: req.username,
                passwd: req.passwd,
                table_list: req.table_list
            }
        }
        return
    }
    let re = /^[a-zA-Z0-9 _]*$/
    if (!re.test(req.table_list)) {
        this.body = {
            code: "0001", msg: "表名与表名请使用空格进行分隔", data: {
                table_list: req.table_list
            }
        }
        return
    }
    try {
        let new_db = {
            dbname: req.dbname.trim(),
            ip: req.ip.trim(),
            port: parseInt(req.port),
            username: req.username.trim() || default_username,
            passwd: req.passwd.trim() || default_passwd,
            table_list: req.table_list.trim() || "",
            update_at: req.update_at
        }
        console.log(req)
        if (req._id) {
            this.body = await this.mongo("dbconfig").updateById(req._id, new_db);
        } else {
            this.body = await this.mongo("dbconfig", new_db).saveByName(req.dbname, req);
        }
    } catch (error) {
        console.log(error)
        console.log(typeof error)
        this.body = {
            code: "0001", msg: error.toString(), data: {
                dbname: req.dbname,
                ip: req.ip,
                port: req.port,
                username: req.username,
                passwd: req.passwd,
                table_list: req.table_list,
                update_at: req.update_at
            }
        }
    }
}

exports.get_db_config = async function () {
    await this.bindDefault();
    let db_configs = await this.mongo("dbconfig").getDBConfig({}, {}, { dbname: 1 });
    for (let db of db_configs) {
        if (db.username === default_username) {
            db.username = ''
        }
        if (db.passwd === default_passwd) {
            db.passwd = ''
        }
        // process.env.TZ = 'Asia/Shanghai';
        // db.update_at = db.update_at.toLocaleString()
    }
    this.body = db_configs;
}

exports.delete = async function () {
    await this.bindDefault();
    try {
        await this.mongo("dbconfig").delete(this.request.query._id)
        this.body = { code: "0002" }
    } catch (error) {
        //执行不到这里，即使删除前将要删除的记录手动删除了，也不会报错
        this.body = { code: "0001", msg: "删除失败" }
    }
    console.log(111, this.body)
    // item = await this.mongo("dbconfig").delete(this.request.query._id);
    // this.body = item
}
exports.delete.__method__ = 'get';

exports.get_dbs = async function () {
    await this.bindDefault
    let dbs = await this.mongo("dbconfig").getDBConfig({}, { "_id": 0, "dbname": 1 }, { dbname: 1 })
    this.body = dbs
}
exports.get_dbs.__method__ = 'get'



exports.db_sync = async function () {
    await this.bindDefault
    let req = this.request.body
    console.log(req)
    // if (req.replace_ip === '' || req.sync_db_name == '' || req.sync_db_name == undefined || req.target_db_port == '') {
    //     this.body = {
    //         code: "0001", msg: "有必填项没有填写", data: {
    //             sync_db_name: req.sync_db_name,
    //             target_db_host: req.target_db_host,
    //             target_db_port: req.target_db_port,
    //             replace_ip: req.replace_ip,
    //             not_delete_business_data: req.not_delete_business_data,
    //             use_cache: req.use_cache
    //         }
    //     }
    //     return
    // }

    // if (req.target_db_host > 0 && req.target_db_host < 256) {
    //     req.target_db_host = '192.168.4.' + req.target_db_host
    // }
    // console.log(req.target_db_host)

    // re = /^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$/
    // if (!re.test(req.target_db_host)) {
    //     this.body = { code: "0001", msg: "target_db_host不正确" }
    //     return
    // }

    // console.log(parseInt(req.target_db_port))
    // if (parseInt(req.target_db_port) < 1 || parseInt(req.target_db_port) > 65535 || isNaN(parseInt(req.target_db_port))) {
    //     this.body = { code: "0001", msg: "target_db_port不正确" }
    //     return
    // }

    if (req.sync_db_name == '' || req.sync_db_name == undefined || req.name_space == '') {
        this.body = {
            code: "0001", msg: "有必填项没有填写", data: {
                name_space: req.name_space,
                sync_db_name: req.sync_db_name,
                not_delete_business_data: req.not_delete_business_data,
                use_cache: req.use_cache
            }
        }
        return
    }

    let list_env_vars = function (namespace) {
        this.url = `http://${eos_host}/api/apollo/env_vars?namespace=${namespace}`
        this.method = "GET"
    }

    function requestPromise(option) {
        return new Promise(function (resolve, reject) {
            request(option, function (err, res, body) {
                if (err) {
                    resolve({ code: "0001", err: err })
                } else {
                    resolve(body)
                }
            })
        })
    }

    let opt = new list_env_vars(req.name_space)
    let env_vars = await requestPromise(opt)
    env_vars = JSON.parse(env_vars)

    let sync_db_name = req.sync_db_name
    let target_db_host = env_vars.details.DB_SERVICE_HOST
    let target_db_port = env_vars.details.DB_SERVICE_PORT
    let replace_ip = req.name_space
    let not_delete_business_data = req.not_delete_business_data
    let use_cache = req.use_cache
    // let a = {
    //     depth: 1,
    //     "sync_db_name": sync_db_name,
    //     "target_db_host": target_db_host,
    //     "target_db_port": target_db_port,
    //     "re_replace_ip": replace_ip,
    //     "not_delete_business_data": not_delete_business_data,
    //     "use_cache": use_cache,
    // }
    // console.log(a)
    // return


    function requestJenkinsBuildPromise(job, option) {
        return new Promise(function (resolve, reject) {
            jenkins.build_with_params(job, option, function (err, data) {
                if (err) {
                    resolve({ code: "0001", err: err })
                }
                else {
                    resolve(data)
                }
            })
        })
    }

    function requestJenkinsBuildInfoPromise(job, option) {
        return new Promise(function (resolve, reject) {
            jenkins.build_info(job, option, function (err, data) {
                if (err) {
                    resolve({ code: "0001", err: err })
                }
                else {
                    resolve(data)
                }
            })
        })
    }

    function sleep(ms) {
        return new Promise(resolve => setTimeout(resolve, ms))
    }

    var res = {}
    res = await requestJenkinsBuildPromise('sync_database_schema', {
        depth: 1,
        "sync_db_name": sync_db_name,
        "target_db_host": target_db_host,
        "target_db_port": target_db_port,
        "re_replace_ip": replace_ip,
        "not_delete_business_data": not_delete_business_data,
        "use_cache": use_cache,
    })

    console.log(88, res)

    // var api_json = '', build_info = {}

    // do {
    //     console.log("waiting queue...")
    //     await sleep(1000)
    //     api_json = await requestPromise(res.location + "api/json")
    // } while (api_json.indexOf("number") < 0)
    // console.log(111, api_json)

    // do {
    //     console.log("waiting build...")
    //     await sleep(500)
    //     build_info = await requestJenkinsBuildInfoPromise('sync_database_schema', JSON.parse(api_json).executable.number)
    // } while (build_info.building)

    // console.log(111, build_info)

    // let default_target_username = 'qa'
    // let default_target_passwd = 'qatest'

    // //异步
    // console.log(`sh /home/qa-deploy-utils/db-utils/db_schema_sync.sh ${target_db_host} ${default_target_username} ${default_target_passwd} ${sync_db_name} ${replace_ip} ${not_delete_business_data} ${use_cache} ${target_db_port}`)

    // cproc.exec(`sh /home/qa-deploy-utils/db-utils/db_schema_sync.sh ${target_db_host} ${default_target_username} ${default_target_passwd} ${sync_db_name} ${replace_ip} ${not_delete_business_data} ${use_cache} ${target_db_port}`, function (err, stdout, stderr) {
    //     if (err) {
    //         console.log('get error' + err)
    //         this.body = { code: "0001", msg: "出错了" }
    //         return
    //     } else {
    //         console.log(222)
    //         console.log(stdout)
    //         var data = JSON.parse(stdout)
    //         this.body = { code: "0000", msg: data }
    //     }
    // })

    // // 同步
    // // let dir = '/Users/zhiyong/IdeaProjects/coding/qaHome'
    // // let aaa = String(execSync(`sleep 1;cd "$dir";pwd`))
    // // console.log(aaa)

    this.body = {
        code: "0000", msg: { location: res.location }
    }

    try {
        this.logger.info(
            " active:", "db_sync",
            "namespace:", req.name_space,
            "sync_db_name:", req.sync_db_name,
            "not_delete_business_data:", req.not_delete_business_data,
            "use_cache:", req.use_cache,
            " user:", this.user);
    } catch (error) {

    }

}

exports.db_sync_query = async function () {
    await this.bindDefault
    var api_json = '', build_info = {}, log_info = {}
    let req = this.request.body

    function requestPromise(option) {
        return new Promise(function (resolve, reject) {
            request(option, function (err, res, body) {
                if (err) {
                    resolve({ code: "0001", err: err })
                } else {
                    resolve(body)
                }
            })
        })
    }

    function requestJenkinsBuildInfoPromise(job, option) {
        return new Promise(function (resolve, reject) {
            jenkins.build_info(job, option, function (err, data) {
                if (err) {
                    resolve({ code: "0001", err: err })
                }
                else {
                    resolve(data)
                }
            })
        })
    }

    function requestJenkinsConsoleInfoPromise(job, option) {
        return new Promise(function (resolve, reject) {
            jenkins.console_output(job, option, function (err, data) {
                if (err) {
                    resolve({ code: "0001", err: err })
                }
                else {
                    resolve(data)
                }
            })
        })
    }

    function sleep(ms) {
        return new Promise(resolve => setTimeout(resolve, ms))
    }

    api_json = await requestPromise(jenkins_user_pwd + req.location.replace('http://', '') + "api/json")
    // api_json = await requestPromise(req.location.replace('http://', '') + "api/json")

    if (typeof api_json == 'string') {
        if (api_json.indexOf("number") > 0) {
            build_info = await requestJenkinsBuildInfoPromise('sync_database_schema', JSON.parse(api_json).executable.number)
            log_info = await requestJenkinsConsoleInfoPromise('sync_database_schema', JSON.parse(api_json).executable.number)
            console.log(333, build_info.building)
            if (build_info.building) {
                this.body = { code: "0001", msg: { status: "building", building: true }, log: log_info }
            }
            else {
                this.body = { code: "0000", msg: build_info, log: log_info }
            }
        } else {
            this.body = { code: "0001", msg: { status: "queue", building: true }, log: { body: "" } }
        }
    } else {
        console.log("获取队列信息出错", req.location)
        console.log(api_json)
        this.body = { code: "0002", msg: "获取队列信息出错" }
    }

} 
