'use strict';
var request = require('request');
var moment = require('moment');

function requestPromise(option) {
    return new Promise(function (resolve, reject) {
        request(option, function (err, res, body) {
            if (err) {
                reject(err)
            } else {
                resolve(body)
            }
        })
    })
}

let ns_option = function () {
    this.url = "http://192.168.4.96:9000/get_namespace";
    this.method = "GET";
}
let device_option = function (key) {
    this.url = `http://192.168.4.96:9000/get_env_info?namespace=${key}&option=all`;
    this.method = "GET";
}
let hosts_option = function () {
    this.url = `http://192.168.4.3:10088/config_server/get_hosts`;
    this.method = "GET";
}
let restart_pod = function (body) {
    this.url = `http://192.168.4.96:9000/openapi/restart_system`;
    this.method = "POST"
    this.body = body;
    this.json = true;
}
let delete_pod = function (body) {
    this.url = `http://192.168.4.96:9000/openapi/delete_system`;
    this.method = "POST"
    this.body = body;
    this.json = true;
}

let get_pod_info = function (namespace, system_name) {
    this.url = `http://192.168.4.23:8000/v2/keys/${namespace}/${system_name}`;
    this.method = "GET"
}
let get_pod_infos = function (namespace) {
    this.url = `http://192.168.4.96:9000/openapi/list_system?namespace=${namespace}`
    this.method = "GET"
}

function have_console(keys) {
    let r = false;
    for (let i of keys) {
        if (i.name == 'console') {
            r = true
            break
        }
    }
    return r
}
function formatInfo(str) {
    let res = JSON.parse(str);
    let info = {
        info: {},
        pod_status: "-",
        host_ip: "",
        http_port: "",
        console_port: "",
        log_port: "",
        live: "00:00:00",
        status: "-"
    }
    if (res.node) {
        for (let i of res.node.nodes) {
            if (i.key.indexOf("host_ip") != -1) {
                info.host_ip = i.value
            } else if (i.key.indexOf("http_port") != -1) {
                info.http_port = i.value
            } else if (i.key.indexOf("status") != -1) {
                info.status = i.value
            } else if (i.key.indexOf("details")) {
                let temp = JSON.parse(i.value);
                // info.info = temp
                for (let a of temp.ports) {
                    if (a.name == 'console') {
                        info.console_port = a.node_port
                    } else if (a.name == 'log') {
                        info.log_port = a.node_port
                    }
                }
                info.image = temp.image;
                info.pod_name = temp.pod_name;
                info.pod_ip = temp.pod_ip;
                info.pod_status = temp.phase;
                let dif = new Date() - new Date(temp.start_time);
                if (dif) {
                    info.live = moment.unix(dif).format("HH:mm:ss");
                }
            }
        }
    }

    return info
}

exports.refresh_name_space = async function () {
    await this.bindDefault();
    let res = await requestPromise(new ns_option());
    let nss = res.split("\n");
    for (let k of nss) {
        let opt = new device_option(k)
        let dev = await requestPromise(opt);
        let item = {
            name_space: k,
            devices: JSON.parse(dev)["details"]
        }
        let ii = await this.mongo("Docker", item).saveNameSpace(item);
    }
    this.body = { code: "0000" }
    return
}
exports.refresh_name_space.__method__ = 'get';

exports.get_name_space = async function () {
    await this.bindDefault();
    let res = await requestPromise(new ns_option());
    this.body = res.split("\n");
    return
}
exports.get_name_space.__method__ = 'get';



function cal(length) {
    this.number = length
}
cal.prototype = {
    back: function () {
        this.number--;
    },
    finished: function () {
        if (this.number <= 0) {
            return true
        } else {
            return false
        }
    }
}

function asyncCycle(namespace, loop) {
    return new Promise(function (resolve, reject) {
        var gl = new cal(loop.length);
        let infos = {};
        for (let l of loop) {
            let opt = new get_pod_info(namespace, l);
            let res = request(opt, function (err, res, body) {
                if (err) {
                    infos[l] = {}
                } else {
                    infos[l] = formatInfo(body)
                }
                gl.back();
                if (gl.finished()) {
                    resolve(infos)
                }
            });
        }
    })
}



exports.get_devices_info = async function () {
    await this.bindDefault();
    let systems = this.request.query.systems.split(",")
    this.body = await asyncCycle(this.request.query.namespace, systems)
    return
}
exports.get_devices_info.__method__ = "get";

exports.get_device = async function () {
    await this.bindDefault();
    let self = this;
    let opt = new get_pod_infos(this.request.query.namespace);
    // new device_option(this.request.query.namespace)
    let opth = new hosts_option()

    // let opt = new get_pod_infos(this.request.body.namespace);
    // let res = await requestPromise(opt);
    // res = JSON.parse(res);


    let dev = await requestPromise(opt);
    let hosts = await requestPromise(opth);

    dev = JSON.parse(dev);
    hosts = JSON.parse(hosts);
    let arr = [], arr2 = [], arr3 = [];
    let items = dev.details;//JSON.parse(dev.details);
    let keys = Object.keys(items);
    // "traefik", "db", "rabbitmq", "*redis"
    for (let k of keys) {
        let tem = {
            name: k,
            host: "",
            ip: items[k].host_ip,
            health: items[k].phase,
            info: {},
            console: false
        }
        if (have_console(items[k].ports)) {
            tem.console = true
        }
        if (hosts[k] != undefined) {
            tem.host = hosts[k].replace(".xyqb.com", `-${self.request.query.namespace}.q-gp.com`).replace(".quantgroup.cn", `-${self.request.query.namespace}.q-gp.com`)
        }
        if ((k === "traefik") || (k.indexOf("redis") != -1) || (k === "db") || (k === "rabbitmq") || (k === "zookeeper")) {
            tem.ports = items[k].ports
            arr2.push(tem)
        } else if (k.indexOf("ui") != -1) {

            arr3.push(tem)
        } else {

            arr.push(tem)
        }
    }
    this.body = {
        base: arr2,
        buss: arr,
        ui: arr3
    }
    return
}
exports.get_device.__method__ = 'get';

exports.restart_system = async function () {
    await this.bindDefault();
    let opt = new restart_pod(this.request.body);
    let res = await requestPromise(opt);
    this.body = {
        msg: res
    }
    return
}
exports.restart_system.__method__ = 'post';

// 
exports.delete_system = async function () {
    await this.bindDefault();
    let opt = new delete_pod(this.request.body);
    let res = await requestPromise(opt);
    this.body = {
        code: "0000",
        msg: res
    }
    // this.body = {
    //     code: "0001",
    //     msg: "服务暂不开放"
    // }
    return
}
exports.delete_system.__method__ = 'post';

exports.get_pod_info = async function () {
    await this.bindDefault();
    let opt = new get_pod_info(this.request.body.namespace, this.request.body.system_name);
    let res = await requestPromise(opt);
    this.body = await formatInfo(res)
    return
}
exports.get_pod_info.__method__ = 'post';

exports.get_pod_infos = async function () {
    await this.bindDefault();
    let opt = new get_pod_infos(this.request.body.namespace);
    let res = await requestPromise(opt);
    res = JSON.parse(res);
    this.body = res.details
    return
}
exports.get_pod_infos.__method__ = 'post';
