'use strict';

exports.model = 'NameSpaceGroup';
exports.schema = [{
    name_space: { type: String, unique: true, required: false, index: false },
    group: { type: String, unique: false, required: false, index: false }

}, {
    autoIndex: false,
    versionKey: false
}]

// 静态方法:http://mongoosejs.com/docs/guide.html#statics
exports.statics = {}

// http://mongoosejs.com/docs/guide.html#methods
exports.methods = {
    set: async function (name, group) {
        let item = await this.model("NameSpaceGroup").findOne({ name_space: name });
        if(item === null){
            await this.model("NameSpaceGroup").create({ name_space: name, group: group});
        }else {
            await this.model("NameSpaceGroup").updateOne({ "_id": item._id }, { group: group});
        }
        return {code: "0000"}
    },
    getByGroupByNameSpace: async function (name) {
        let item =  await this.model("NameSpaceGroup").findOne({ name_space: name });
        if(item === null){
            await this.model("NameSpaceGroup").create({ name_space: name, group: "测试" });
            return "测试"
        }else{
            return item.group
        }
    },
    delete: async function(name) {
        await this.model("NameSpaceGroup").remove({ name_space: name });
        return {code :"0000"}
    }
}