exports.get_index_url = async function () {
    await this.bindDefault();
    let re = [];
    let work_list = await this.mongo("IndexUrl").getIndexUrl({ type: "work" }, { remark: 1 });
    let big_data_list = await this.mongo("IndexUrl").getIndexUrl({ type: "data" }, { remark: 1 });
    let test_list = await this.mongo("IndexUrl").getIndexUrl({ type: "test" }, { remark: 1 });
    let tech_list = await this.mongo("IndexUrl").getIndexUrl({ type: "tech" }, { remark: 1 });
    let moniter_list = await this.mongo("IndexUrl").getIndexUrl({ type: "moniter" }, { remark: 1 });
    let favorite_list = await this.mongo("IndexUrl").getIndexUrl({ type: "favorite" }, { remark: 1 });

    re.push({ name: work_list[0].type_name, data: work_list, class: "primary" });
    re.push({ name: moniter_list[0].type_name, data: moniter_list, class: "danger" });
    re.push({ name: test_list[0].type_name, data: test_list, class: "success" });
    re.push({ name: tech_list[0].type_name, data: tech_list, class: "info" });
    re.push({ name: big_data_list[0].type_name, data: big_data_list, class: "warning" });
    re.push({ name: favorite_list[0].type_name, data: favorite_list, class: "accent" });

    this.body = re;
    return
}
exports.get_index_url.__method__ = 'get';

exports.delete = async function () {
    await this.bindDefault();
    let item = await this.mongo("IndexUrl").delete(this.request.query._id);
    this.body = item
    return
}
exports.delete.__method__ = 'get';


exports.save = async function () {
    let req = this.request.body;
    if (req.remark == '' || req.url == '' || req.type_name == '') {
        this.body = {
            code: "0001", msg: "有必填项没有填写", data: {
                remark: req.remark,
                url: req.url,
                type_name: req.type_name
                // is_active: req.is_active
            }
        }
        return
    }

    if (req.url.indexOf("http")) {
        this.body = { code: "0001", msg: "url地址中须包括http://" }
        return
    }

    try {
        let new_index = {
            remark: req.remark,
            url: req.url,
            type_name: req.type_name
        }
        new_index.type = await this.mongo("IndexUrl").getType(new_index.type_name);

        console.log(new_index)
        if (req._id) {
            this.body = await this.mongo("IndexUrl").updateById(req._id, new_index);
        } else {
            this.body = await this.mongo("IndexUrl", new_index).saveByUrl(req.url, req);
        }
    } catch (error) {
        console.log(error)
        this.body = {
            code: "0001", msg: "错误", data: {
            }
        }
    }
}
