'use strict';
var request = require('request');
var moment = require('moment');
var redis = require('redis');
var new_os_key = "";

function cal(length) {
    this.number = length
}
cal.prototype = {
    back: function () {
        this.number--;
    },
    finished: function () {
        if (this.number <= 0) {
            return true
        } else {
            return false
        }
    }
}

function requestPromise(option) {
    return new Promise(function (resolve, reject) {
        request(option, function (err, res, body) {
            if (err) {
                resolve({ code: "0001", err: err })
                // reject()
            } else {
                resolve(body)
            }
        })
    })
}

function generateUUID() {
    var d = new Date().getTime();
    var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var r = (d + Math.random() * 16) % 16 | 0;
        d = Math.floor(d / 16);
        return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
    });
    return uuid;
};

let ros_host = "192.168.6.13";
let pro_host = "192.168.4.3:10088";
var eos_host = 'eos.quantgroups.com'

// etcd直接获取信息
let get_pod_info = function (namespace, system_name) {
    //  老环境获取pod内容
    this.url = `http://192.168.4.23:8000/v2/keys/${namespace}/${system_name}`;
    this.method = "GET"
}
// namespace -视角 
let list_images = function (system_name) {
    this.url = `http://${ros_host}/api/qahome/list_images?microservice_name=${system_name}`;
    this.method = "GET";
}
let ns_option = function () {
    this.url = `http://${ros_host}/api/qahome/list_env`;
    this.method = "GET";
}
let delete_namespace = function (body) {
    this.url = `http://${ros_host}/api/qahome/destroy_env`;
    this.method = "DELETE"
    this.body = body;
    this.json = true;
}
let init_env = function (body) {
    this.url = `http://${ros_host}/api/qahome/init_env`;
    this.method = "POST"
    this.body = body;
    this.json = true;
}
let clone_env = function (body) {
    this.url = `http://${ros_host}/api/qahome/clone_env`;
    this.method = "POST"
    this.body = body;
    this.json = true;
}
let list_preset = function () {
    // 获取服务编排
    this.url = `http://${ros_host}/api/qahome/list_preset`;
    this.method = "GET";
}

let list_hang_up_env = function () {
    this.url = `http://${ros_host}/api/qahome/list_hang_up_env`;
    this.method = "GET"
}

let hang_up_env = function (body) {
    this.url = `http://${ros_host}/api/qahome/hang_up_env`;
    this.method = "POST"
    this.body = body;
    this.json = true;
}
let recovery_hangup_up_env = function (body) {
    this.url = `http://${ros_host}/api/qahome/recovery_hang_up_env`;
    this.method = "POST"
    this.body = body;
    this.json = true;
}
let destroy_hang_up_env = function (body) {
    this.url = `http://${ros_host}/api/qahome/destroy_hang_up_env`;
    this.method = "DELETE"
    this.body = body;
    this.json = true;
}
// 具体服务 -视角
let get_microservice = function (namespace, system_name) {
    // 新环境获取pod内容
    this.url = `http://${ros_host}/api/qahome/get_microservice?name=${system_name}&namespace=${namespace}`;
    this.method = "GET"
}
let get_env_progress = function (namespace) {
    // 新环境获取pod内容
    this.url = `http://${ros_host}/api/qahome/get_env_progress?namespace=${namespace}`;
    this.method = "GET"
}
let list_microservice = function (namespace) {
    this.url = `http://${ros_host}/api/qahome/list_microservice?namespace=${namespace}`
    this.method = "GET"
}
let restart_microservice = function (body) {
    this.url = `http://${ros_host}/api/qahome/restart_microservice`;
    this.method = "POST"
    this.body = body;
    this.json = true;
}
let create_microservice = function (body) {
    this.url = `http://${ros_host}/api/qahome/create_microservice`;
    this.method = "POST"
    this.body = body;
    this.json = true;
}
let update_microservice = function (body) {
    this.url = `http://${ros_host}/api/qahome/update_microservice`;
    this.method = "PUT"
    this.body = body;
    this.json = true;
}
let delete_microservice = function (body) {
    this.url = `http://${ros_host}/api/qahome/delete_microservice`;
    this.method = "DELETE"
    this.body = body;
    this.json = true;
}
var delete_preset = function (body) {
    this.method = 'DELETE';
    this.url = `http://${ros_host}/api/qahome/delete_preset`;
    this.body = body;
    this.json = true;
};
var save_preset = function (body) {
    this.method = 'POST';
    this.url = `http://${ros_host}/api/qahome/save_preset`;
    this.body = body;
    this.json = true;
};

let list_env_vars = function (namespace) {
    this.url = `http://${eos_host}/api/apollo/env_vars?namespace=${namespace}`
    this.method = "GET"
}

// 4.3 环境获取信息使用
let get_systems_by_type = function () {
    this.url = `http://${pro_host}/config_server/get_systems_by_type`;
    this.method = "GET";
}
let hosts_option = function () {
    this.url = `http://${pro_host}/config_server/get_hosts`;
    this.method = "GET";
}


// 同步MQ命令
let get_definitions = function () {
    this.url = 'http://172.30.3.140:15672/api/definitions';
    this.headers = { 'Authorization': 'Basic cmFiYml0X2FkbWluOmFiYzEyMzQ=' };
    this.method = "GET";
}
let set_definitions = function (host, body) {
    this.url = `http://${host}/api/definitions`;
    this.headers = { 'Authorization': 'Basic cWE6cWF0ZXN0' };
    this.method = "POST";
    this.body = body;
    this.json = true;
}

function have_console(obj) {
    let r = {
        have: false,
        console_port: "",
        log_port: "",
        debug_port: ""
    };
    if (obj == undefined) {
        return r
    }
    if (obj.ports == undefined) {
        return r
    }
    for (let i of obj.ports) {
        if (i.name == 'console') {
            r.have = true;
            r.console_port = i.node_port
        } else if (i.name == 'log') {
            r.log_port = i.node_port
        } else if (i.name == 'debug') {
            r.debug_port = i.node_port
        }
    }

    return r
}
function getTimeDiff(then) {
    let a = moment(then).startOf('minute').fromNow();
    return a
}
function formatInfo(obj) {

    // let obj = args[0];
    let time_then = new Date(obj.start_time);
    // obj.service = obj.service[0];
    let post_info = have_console(obj.service);
    let branch = "";
    let branch_no_time = "";
    let branch_time = "";
    try {
        branch = obj.image.split(":")[1];
        branch_no_time = obj.image.split(":")[1].split("-")[0];
        branch_time = obj.image.split(":")[1].split("-")[1];
    } catch (error) {
        console.log(obj.image)
    }
    let info = {
        image: obj.image,
        name: obj.microservice_name || "",
        branch: branch,
        branch_no_time: branch_no_time,
        branch_time: branch_time,
        host: "",
        host_ip: obj.host_ip || "",
        health: "",
        ports: [],
        console: post_info.have || false,
        console_port: post_info.console_port || "",
        log_port: post_info.log_port || "",
        debug_adr: post_info.debug_port ? `${obj.host_ip}:${post_info.debug_port}` : "",
        http_port: "",
        pod_status: obj.pod_status || "-",
        pod_ip: obj.pod_ip || "",
        live: getTimeDiff(time_then),
        status: obj.microservice_status || "-",
        type: obj.tier
    }
    if (obj.service != undefined && obj.service.ports != undefined) {
        info.ports = obj.service.ports
    }
    //  设定host名称
    if (obj.ingress != undefined) {
        if (obj.ingress.rules != undefined) {
            if (obj.ingress.rules[0].host != undefined) {
                info.host = obj.ingress.rules[0].host;
            }
        }
    }
    return info
}


async function formatListData(res, db) {
    for (let i of res.details.instances) {
        i.disabled = true;
        i.creation_timestamp = moment(i.creation_timestamp).format("YYYY-MM-DD hh:mm:ss");
        if (i.status == "Active") {
            i.stauts_name = "正常";
            i.disabled = false;
        } else if (i.status == "Pending") {
            i.stauts_name = "正在创建";
        } else if (i.status == "Terminating") {
            i.stauts_name = "删除中";
        } else {
            i.stauts_name = "异常";
        }
        let group = await db.getByGroupByNameSpace(i.name);
        i.group_name = group;
        i.job_is_working = false;
        i.job_status_name = "";
        i.progress = {};
        if (i.init_status === 'init') {
            i.job_is_working = true;
            i.job_status_name = "处理中";
        }
    }
}
exports.set_group = async function () {
    await this.bindDefault();
    this.body = await this.mongo("NameSpaceGroup").set(this.request.body.name_space, this.request.body.group);
    return
}
exports.set_group.__method__ = 'post';

exports.get_groups = async function () {
    await this.bindDefault();
    this.body = ['内部-开发', '内部-测试', '外部-开发', '外部-测试', '导流-开发', '导流-测试', '海外-开发', '海外-测试', '基础', '数据', '安全', '运维', '测试']
    return
}
exports.get_groups.__method__ = 'get';

exports.get_name_space = async function () {
    await this.bindDefault();
    let res = await requestPromise(new ns_option());
    if (typeof res == "string") {
        res = JSON.parse(res);
    }
    let db = this.mongo("NameSpaceGroup");
    await formatListData(res, db);
    this.body = res.details.instances;
    return
}
exports.get_name_space.__method__ = 'get';

function asyncCycleForProgress(namespaces) {
    return new Promise(function (resolve, reject) {
        var gl = new cal(namespaces.length);
        let infos = {};
        for (let l of namespaces) {
            let opt = new get_env_progress(l);
            let res = request(opt, function (err, res, body) {
                let _body = body;
                if (typeof _body == "string") {
                    _body = JSON.parse(_body);
                }
                if (err) {
                    infos[l] = {}
                } else {
                    infos[l] = {
                        progress: _body.details.progress,
                        status: _body.details.status,
                        msg: _body.details.msg
                    }
                }
                gl.back();
                if (gl.finished()) {
                    resolve(infos)
                }
            });
        }
    })
}


exports.refresh_name_space_progress = async function () {
    await this.bindDefault();
    let ns = this.request.body.namespaces;
    let re = await asyncCycleForProgress(ns);
    this.body = re
    return
}
exports.refresh_name_space_progress.__method__ = 'post';

function getSameFormatObj(str) {
    let obj = str;
    if (typeof str == 'string') {
        obj = JSON.parse(str)
    }
    let item = obj.details.instances[1].pods_info[0];
    item.service = obj.details.instances[2].service;
    item.ingress = obj.details.instances[3].ingress;
    return item
}

function asyncCycle(namespace, loop) {
    return new Promise(function (resolve, reject) {
        var gl = new cal(loop.length);
        let infos = {};
        for (let l of loop) {
            let opt = new get_microservice(namespace, l);
            let res = request(opt, function (err, res, body) {
                if (err) {
                    infos[l] = {}
                } else {
                    infos[l] = formatInfo(getSameFormatObj(body))
                }
                gl.back();
                if (gl.finished()) {
                    resolve(infos)
                }
            });
        }
    })
}



exports.get_devices_info = async function () {
    await this.bindDefault();
    if (this.request.query.systems) {
        let systems = this.request.query.systems.split(",")
        this.body = await asyncCycle(this.request.query.namespace, systems)
    } else {
        this.body = []
    }

    return
}
exports.get_devices_info.__method__ = "get";

exports.get_device = async function () {
    await this.bindDefault();
    let self = this;
    let opt = new list_microservice(this.request.query.namespace);
    // let opth = new hosts_option()
    let dev = await requestPromise(opt);
    // let hosts = await requestPromise(opth);
    dev = JSON.parse(dev);
    // hosts = JSON.parse(hosts);
    let buss = [], base = [], ui = [];
    let items = dev.details.instances;
    for (let item of items) {
        let k = item.microservice_name;
        let tmp = {};
        tmp = formatInfo(item);
        if (tmp.type == "frontend") {
            ui.push(tmp)
        } else if (tmp.type == "common") {
            base.push(tmp)
        } else if (tmp.type == "backend") {
            buss.push(tmp)
        }

    }
    this.body = {
        common: base,
        backend: buss,
        frontend: ui
    }
    return
}
exports.get_device.__method__ = 'get';

exports.restart_all_system = async function () {
    await this.bindDefault();
    let body = this.request.body;
    for (let o of body.system_names) {
        let opt = new restart_microservice({
            microservice_name: o,
            namespace: body.namespace
        });
        requestPromise(opt);
    }

    this.body = {
        code: "0000",
        msg: "请求启动成功，请等待2分钟后刷新页面"
    }
    try {
        this.logger.info(
            "namespace:", this.request.body.namespace,
            " active:", "restart_all_microservice",
            " user:", this.user);
    } catch (error) {

    }


    return
}
exports.restart_all_system.__method__ = 'post';

exports.restart_system = async function () {
    await this.bindDefault();
    let opt = new restart_microservice({
        microservice_name: this.request.body.system_name,
        namespace: this.request.body.namespace
    });
    let res = await requestPromise(opt);
    this.body = {
        msg: res
    }
    try {
        this.logger.info(
            "namespace:", this.request.body.namespace,
            " microservice_name:", this.request.body.system_name,
            " active:", "restart_microservice",
            " user:", this.user);
    } catch (error) {
        console.log(this.logger)
    }

    return
}
exports.restart_system.__method__ = 'post';

// 
exports.delete_system = async function () {
    await this.bindDefault();
    let opt = new delete_microservice({
        namespace: this.request.body.namespace,
        name: this.request.body.system_name,
    });
    let res = await requestPromise(opt);
    this.body = {
        code: "0000",
        msg: res
    }
    try {
        this.logger.info(
            "namespace:", this.request.body.namespace,
            " name:", this.request.body.system_name,
            " active:", "delete_microservice",
            " user:", this.user);
    } catch (error) {

    }

    return
}
exports.delete_system.__method__ = 'post';

exports.get_pod_info = async function () {
    await this.bindDefault();
    let opt = new get_microservice(this.request.body.namespace, this.request.body.system_name);
    let res = await requestPromise(opt);
    this.body = await formatInfo(getSameFormatObj(res))
    return
}
exports.get_pod_info.__method__ = 'post';

exports.delete_namespace = async function () {
    await this.bindDefault();
    let opt = new delete_namespace(this.request.body);
    let res = await requestPromise(opt);
    this.body = {
        code: "0000",
        msg: res
    }
    try {
        this.logger.info(
            "namespace:", this.request.body,
            " active:", "delete_namespace",
            " user:", this.user);
    } catch (error) {

    }

    return
}
exports.delete_namespace.__method__ = 'post';

exports.clone_namespace = async function () {
    await this.bindDefault();
    let _self = this;
    let res = await requestPromise(new ns_option());
    res = JSON.parse(res)
    let msg = `将要创建一个新的NameSpace:${_self.request.body.to_namespace}`;
    for (let o of res.details.instances) {
        if (_self.request.body.to_namespace == o.name) {
            msg = `${_self.request.body.to_namespace}已经存在，请更换名称！`
            break;
        }
    }
    let opt = new clone_env(this.request.body);
    res = await requestPromise(opt);
    this.body = {
        code: "0000",
        msg: msg,
        back: res
    }
    try {
        this.logger.info(
            "namespace:", this.request.body,
            " active:", "clone_env",
            " user:", this.user);
    } catch (error) {

    }

    return
}
exports.clone_namespace.__method__ = 'post';

exports.create_custom_namespace = async function () {
    await this.bindDefault();
    let _self = this;
    let res = await requestPromise(new ns_option());
    res = JSON.parse(res);
    if (_self.request.body.code != new_os_key) {
        this.body = {
            code: "0001", msg: " 创建确认码不正确"
        }
        return
    }
    let flg = false;
    for (let o of res.details.instances) {
        if (_self.request.body.namespace == o.name) {
            this.body = {
                code: "0001",
                msg: `${_self.request.body.namespace}已经存在，请更换名称！`
            }
            flg = true;
            break;
        }
    }
    if (flg) {
        return
    }
    let sys = this.request.body.systems;
    let keys = Object.keys(sys);
    let microservices = {
        common: [],
        backend: [],
        frontend: []
    }
    for (let k of keys) {
        for (let item of sys[k]) {
            if (item.select) {
                microservices[k].push(item.label)
            }
        }
    }

    let opt = new init_env({
        namespace: _self.request.body.namespace,
        microservices: microservices
    });
    res = await requestPromise(opt);
    new_os_key = generateUUID();
    this.body = {
        code: "0000",
        msg: res
    }
    try {
        this.logger.info(
            "namespace:", _self.request.body.namespace,
            " microservices:", microservices,
            " active:", "init_env",
            " user:", this.user);
    } catch (error) {

    }

    return
}
exports.create_custom_namespace.__method__ = 'post';

function str2Object(str, def) {
    let item = [];
    let item2 = {};
    let items = str;
    if (typeof str == "string") {
        items = str.split(",");
    }

    items.sort()

    for (let i of items) {
        if (def == 1) {
            item.push({
                label: i,
                select: false
            });
        } else {
            item2[i] = true
        }
    }
    if (def == 1) {
        return item
    } else {
        return item2
    }

}
exports.get_systems_by_type = async function () {
    await this.bindDefault();
    let opt = new get_systems_by_type();
    let res = await requestPromise(opt);
    res = JSON.parse(res);

    this.body = {
        common: str2Object(res.common, 1),
        frontend: str2Object(res.frontend, 1),
        backend: str2Object(res.backend, 1)
    }
    return
}
exports.get_systems_by_type.__method__ = 'get';


exports.get_namespace_template = async function () {
    await this.bindDefault();
    let opt = new list_preset();
    let re = [];
    let res = await requestPromise(opt);
    res = JSON.parse(res);

    re.push({
        label: '空白',
        enable_edit: false,
        preset_key: '',
        template: {
            common: {},
            frontend: {},
            backend: {}
        }
    })
    console.log(res)
    for (let temp of res.details.instances) {
        re.push({
            label: temp.preset_name,
            enable_edit: temp.enable_edit,
            preset_key: temp.preset_key,
            template: {
                common: str2Object(temp.details.common, 2),
                frontend: str2Object(temp.details.frontend),
                backend: str2Object(temp.details.backend)
                // common: str2Object(temp.details.common, 2),
                // frontend: str2Object(temp.details.frontend, 2),
                // backend: str2Object(temp.details.backend, 2)
            }
        })
    }

    this.body = re
    return
}
exports.get_namespace_template.__method__ = 'get';

exports.get_images = async function () {
    await this.bindDefault();
    let opt = new list_images(this.request.query.name);
    let res = await requestPromise(opt);
    let imgs = [];
    if (typeof res == "string") {
        res = JSON.parse(res);
    }
    if (res.details && res.details.instances) {
        for (let k of res.details.instances) {
            // imgs.push({
            //     name: k.name,
            //     time: moment(k.created).format('LLL')
            // });
            imgs.push(k.name)
        }
    }
    this.body = imgs;
    return
}
exports.get_images.__method__ = 'get';

exports.create_system = async function () {
    await this.bindDefault();
    let temp = {
        namespace: this.request.body.namespace,
        image: `192.168.4.4/library/${this.request.body.name}:${this.request.body.image}`,
        name: this.request.body.name,
        tier: this.request.body.tier
    }
    let opt = new create_microservice(temp);
    let res = await requestPromise(opt);
    this.body = res;
    try {
        this.logger.info(
            "namespace:", temp,
            " active:", "create_microservice",
            " user:", this.user);
    } catch (error) {

    }

    return
}
exports.create_system.__method__ = 'post';

exports.update_system = async function () {
    await this.bindDefault();
    let temp = {
        namespace: this.request.body.namespace,
        image: `192.168.4.4/library/${this.request.body.name}:${this.request.body.image}`,
        name: this.request.body.name,
        tier: this.request.body.tier
    }
    let opt = new update_microservice(temp);
    let res = await requestPromise(opt);
    this.body = res;
    try {
        this.logger.info(
            "namespace:", temp,
            " active:", "update_microservice",
            " user:", this.user);
    } catch (error) {

    }

    return
}
exports.create_system.__method__ = 'post';

exports.update_host = async function () {
    await this.bindDefault();
    let temp = {
        namespace: this.request.body.namespace,
        name: this.request.body.name,
        host: this.request.body.host
    }
    let opt = new update_microservice(temp);
    let res = await requestPromise(opt);
    this.body = res;
    try {
        this.logger.info(
            "namespace:", temp,
            " active:", "update_microservice",
            " user:", this.user);
    } catch (error) {

    }

    return
}
exports.update_host.__method__ = 'post';

exports.hang = async function () {
    await this.bindDefault();
    let opt = new hang_up_env({
        namespace: this.request.body.namespace
    });
    let res = await requestPromise(opt);
    if (typeof res == "string") {
        res = JSON.parse(res);
    }
    this.body = res;
    try {
        this.logger.info(
            "namespace:", this.request.body.namespace,
            " active:", "hang_up_env",
            " user:", this.user);
    } catch (error) {

    }

    return
}
exports.hang.__method__ = 'post';

exports.query_hang = async function () {
    await this.bindDefault();
    let opt = new list_hang_up_env();
    let res = await requestPromise(opt);
    if (typeof res == "string") {
        res = JSON.parse(res);
    }
    this.body = res.details.instances;
    return
}
exports.query_hang.__method__ = 'get';

exports.recovery_hang = async function () {
    await this.bindDefault();
    let opt = new recovery_hangup_up_env({
        id: this.request.body.id,
        namespace: this.request.body.namespace
    });
    let res = await requestPromise(opt);
    if (typeof res == "string") {
        res = JSON.parse(res);
    }
    this.body = res;
    try {
        this.logger.info(
            "namespace:", this.request.body.namespace,
            " id:", this.request.body.id,
            " active:", "recovery_hangup_up_env",
            " user:", this.user);
    } catch (error) {

    }

    return
}
exports.recovery_hang.__method__ = 'post';

exports.delete_hang = async function () {
    await this.bindDefault();
    let opt = new destroy_hang_up_env({
        id: this.request.body.id,
        namespace: this.request.body.namespace
    });
    let res = await requestPromise(opt);
    if (typeof res == "string") {
        res = JSON.parse(res);
    }
    this.body = res;
    try {
        this.logger.info(
            "namespace:", this.request.body.namespace,
            " id:", this.request.body.id,
            " active:", "destroy_hang_up_env",
            " user:", this.user);
    } catch (error) {

    }

    return
}
exports.delete_hang.__method__ = 'post';

exports.reload_mq = async function () {
    await this.bindDefault();
    let get_mq_opt = new get_definitions();
    let body = await requestPromise(get_mq_opt);
    if (typeof body == "string") {
        body = JSON.parse(body);
    }
    let set_mq_opt = new set_definitions(this.request.body.host, body);
    let res = await requestPromise(set_mq_opt);
    this.body = { code: "0000" };
    try {
        this.logger.info(
            "namespace:", this.request.body.host,
            " active:", "reload_mq",
            " user:", this.user);
    } catch (error) {

    }

    return
}
exports.reload_mq.__method__ = 'post';

exports.get_code = async function () {
    if (new_os_key == "") {
        new_os_key = generateUUID();
    }
    this.body = {
        code: new_os_key
    };
    return
}
exports.get_code.__method__ = 'get';


exports.save_preset = async function () {
    let re = {
        details: {},
        preset_key: this.request.body.preset_key,
        preset_name: this.request.body.preset_name
    };
    let sys = this.request.body.details;
    let keys = Object.keys(sys);
    let microservices = {
        common: [],
        backend: [],
        frontend: []
    }
    for (let k of keys) {
        for (let item of sys[k]) {
            if (item.select) {
                microservices[k].push(item.label)
            }
        }
    }
    re.details = microservices;
    let opt = new save_preset(re);
    let body = await requestPromise(opt);
    this.body = { msg: body, date: re, code: "0000" };
    try {
        this.logger.info(
            "namespace:", re,
            " active:", "reload_mq",
            " user:", this.user);
    } catch (error) {

    }

    return
}
exports.save_preset.__method__ = 'post';

exports.delete_preset = async function () {

    let re = {
        preset_key: this.request.body.preset_key,
        name: this.request.body.preset_name
    };
    let opt = new delete_preset(re);
    let body = await requestPromise(opt);
    this.body = { msg: body, date: re, code: "0000" };
    try {
        this.logger.info(
            "namespace:", re,
            " active:", "reload_mq",
            " user:", this.user);
    } catch (error) {

    }

    return
}
exports.delete_preset.__method__ = 'post';

const Bluebird = require('bluebird')
exports.flush_redis = async function () {
    let req = this.request.query
    let opt = new list_env_vars(req.namespace)
    let env_vars = await requestPromise(opt)
    env_vars = JSON.parse(env_vars)

    if (env_vars.details.REDIS_SERVICE_HOST) {
        let redis_host = env_vars.details.REDIS_SERVICE_HOST
        let redis_port_6379 = env_vars.details.REDIS_SERVICE_PORT_6379
        let redis_port_6380 = env_vars.details.REDIS_SERVICE_PORT_6380
        let redis_port_6381 = env_vars.details.REDIS_SERVICE_PORT_6381
        let redis_port_6382 = env_vars.details.REDIS_SERVICE_PORT_6382
        let redis_port_6383 = env_vars.details.REDIS_SERVICE_PORT_6383

        let redis_config, redisClient, re

        async function flush_all(host, port) {
            console.log(host, port)
            redis_config = {
                "host": host,
                "port": port
            }
            redisClient = redis.createClient(redis_config);

            function clientPromise(client) {
                return new Promise(function (resolve, reject) {
                    client.flushall(function (err, res) {
                        if (err) {
                            resolve({ code: "0001", err: err })
                        } else {
                            console.log(res)
                            resolve(`${host}:${port} ${res}`)
                        }
                    })
                })
            }

            let result = await clientPromise(redisClient)
            redisClient.quit()
            return result
        }

        re = await flush_all(redis_host, redis_port_6379) + ' | '
        re = re + await flush_all(redis_host, redis_port_6380) + ' | '
        re = re + await flush_all(redis_host, redis_port_6381) + ' | '
        re = re + await flush_all(redis_host, redis_port_6382) + ' | '
        re = re + await flush_all(redis_host, redis_port_6383)

        this.body = { code: "0000", msg: `flushall ${re}` };

    } else {
        this.body = { code: "0001", msg: `${opt.url} 没有获取到Redis数据` };
    }

    try {
        this.logger.info(
            "namespace:", req.namespace,
            " active:", "flush_redis",
            " user:", this.user);
    } catch (error) {

    }
}