
/**
 * 初始化配置文件到redis
 */
exports.init = async function () {
    await this.bindDefault();

    return
}
exports.init.__method__ = 'get';

/**
 * 新增/更新一个配置
 */
exports.save = async function () {
    await this.bindDefault();
    // git@git.quantgroup.cn:QG/xyqb.git
    // git@gitabc.xyqb.com:UI/xyqb-ui.git
    let req = this.request.body;
    if (req.git_path == '' || req.port == '' || req.type == '') {
        this.body = {
            code: "0001", msg: "有必填项没有填写", data: {
                git_path: req.git_path,
                port: req.port,
                type: req.type
                // is_active: req.is_active
            }
        }
        return
    }
    try {
        let git_lab = req.git_path.match(/@(.*):/)[1];
        let git_path_group = req.git_path.match(/:(.*)\//)[1];
        let project_name = req.git_path.match(/\/(.*)\.git/)[1];
        console.log(project_name)
        let new_pro = {
            git_lab: git_lab.trim(),
            port: parseInt(req.port),
            is_active: req.is_active,
            type: req.type.trim(),
            git_path: req.git_path.trim(),
            git_path_group: git_path_group.trim(),
            project_name: project_name.trim(),

            host_name: req.host_name.trim() || "",
            log_path: req.log_path.trim() || "",
            config_path: req.config_path.trim() || "",
            des: req.des.trim() || "",
            auth: req.auth.trim() || "",
            jar_path: req.jar_path.trim() || "",
            command1: req.command1.trim() || "",
            command2: req.command2.trim() || "",
            command3: req.command3.trim() || "",
            command4: req.command4.trim() || "",
            command5: req.command5.trim() || "",
            build_command: req.build_command.trim() || "",
            start_command: req.start_command.trim() || "",
            stop_command: req.stop_command.trim() || ""
        }
        console.log(req)
        if (req._id) {
            this.body = await this.mongo("ProConfig").updateById(req._id, new_pro);
            try {
                this.logger.info(
                    {
                        active: "update_proconfig",
                        microservice_name: project_name.trim(),
                        user: `${this.user.name}`,
                        user_mail: `${this.user.mail}`,
                        detail: new_pro
                    });
            } catch (error) {
                console.log(error)
            }
        } else {
            this.body = await this.mongo("ProConfig", new_pro).saveByPath(req.git_path, req);
            try {
                this.logger.info(
                    {
                        active: "new_proconfig",
                        microservice_name: project_name.trim(),
                        user: `${this.user.name}`,
                        user_mail: `${this.user.mail}`,
                        detail: new_pro
                    });
            } catch (error) {
                console.log(error)
            }
        }
    } catch (error) {
        console.log(error)
        this.body = {
            code: "0001", msg: "git地址错误", data: {
                git_path: req.git_path
            }
        }
    }

    // this.model()
    //需要判断是否已经存在这个配置，如果是存在的，则更新配置，如果是不存在的则保存新增一个配置
    return
}
exports.save.__method__ = 'post';

/**
 * 服务关停，不在遍历这个服务
 */
exports.disabled = async function () {
    await this.bindDefault();

    return
}
exports.disabled.__method__ = "get";

/**
 * 清空这个redis
 */
exports.fllush_redis = async function () {
    await this.bindDefault();
    // fllush_redis
    return
}
exports.fllush_redis.__method__ = 'get';

exports.get_project_by_type = async function () {
    await this.bindDefault();
    let re = [];
    let javas = await this.mongo("ProConfig").getProjectByQuery({ type: "java" }, { project_name: 1 });
    let uis = await this.mongo("ProConfig").getProjectByQuery({ type: "ui" }, { project_name: 1 });
    let nodes = await this.mongo("ProConfig").getProjectByQuery({ type: "node" }, { project_name: 1 });
    let pythons = await this.mongo("ProConfig").getProjectByQuery({ type: "python" }, { project_name: 1 });

    re.push({ name: "java", data: javas });
    re.push({ name: "ui", data: uis });
    re.push({ name: "node", data: nodes });
    re.push({ name: "python", data: pythons });
    this.body = re;
    return
}
exports.get_project_by_type.__method__ = 'get';

exports.get_new_port = async function () {
    await this.bindDefault();
    let port = await this.mongo("ProConfig").getNewPort();
    this.body = port + 1;
    return
}
exports.get_new_port.__method__ = 'get';

exports.find_by_query = async function () {
    await this.bindDefault();
    let item = await this.mongo("ProConfig").getProjectByQuery(this.request.body);
    this.body = item
    return
}
exports.find_by_query.__method__ = 'post';

exports.delete = async function () {
    await this.bindDefault();
    let item = await this.mongo("ProConfig").delete(this.request.query._id);
    this.body = item
    try {
        this.logger.info(
            {
                active: "delete_proconfig",
                microservice_name: this.request.query.project_name.trim(),
                user: `${this.user.name}`,
                user_mail: `${this.user.mail}`,
            });
    } catch (error) {
        console.log(error)
    }
    return
}
exports.delete.__method__ = 'get';
