'use strict';
// var mongoose = require('mongoose');
// var Schema = mongoose.Schema;
// model名称，即表名
exports.model = 'Docker';

// 表结构
exports.schema = [{
    name_space: { type: String, unique: true, required: true, tags: { type: [String], index: true}},
    devices: { type: String, unique: false, required: false, tags: { type: [String], index: false }}
}, {
    autoIndex: false,
    versionKey: false
}];

// 静态方法:http://mongoosejs.com/docs/guide.html#statics
exports.statics = {}

// http://mongoosejs.com/docs/guide.html#methods
exports.methods = {
    getNameSpace: async function () {
        let items = await this.model("Docker").find();
        return items
    },
    getDeviceByNameSpace: async function (ns) {
        let na = await this.model("Docker").findOne({"name_space":ns});
        if(!!!na){
            return {code:"0001",msg:"不存在的name_space"}
        }
        return JSON.parse(na.devices)
    },
    saveNameSpace: async function (ns) {
        console.log(ns)
        let na = await this.model("Docker").findOne({ "name_space": ns.name_space });
        console.log("------")
        console.log(na)
        if(!!na){
            return await this.model("Docker").update({ "name_space": ns.name_sapce }, ns)
        }else{
            return this.save();
        }
    }
}

// db.templateurlroutes.update({},{$set:{last_version:"",relace_version:"",relace_flg:1}},{ multi: true })