import axios from 'axios'
import { Message } from 'element-ui'

// create an axios instance
const serviceTestData = axios.create({
  baseURL: process.env.TESTDATA_API,
  timeout: 5000 // request timeout
})

// request interceptor
serviceTestData.interceptors.request.use(
)

// response interceptor
serviceTestData.interceptors.response.use(
  response => response,
  error => {
    console.log('err' + error) // for debug
    Message({
      message: error.message,
      type: 'error',
      duration: 5 * 1000
    })
    return Promise.reject(error)
  }
)

export default serviceTestData
