import request from '@/utils/requestPipeline'

export function getApplications(data) {
  return request({
    url: '/manage/application/find',
    method: 'post',
    data
  })
}

export function saveApplication(data) {
  return request({
    url: '/manage/application',
    method: 'post',
    data
  })
}

export function updateApplication(data) {
  return request({
    url: '/manage/application',
    method: 'put',
    data
  })
}

export function getRepos() {
  return request({
    url: '/manage/git/find/repo/all',
    method: 'get'
  })
}

export function getRefs(ref) {
  return request({
    url: `/manage/git/find/repo/${ref}/ref`,
    method: 'get'
  })
}

export function deleteApplication(params) {
  return request({
    url: `/manage/application/${params}`,
    method: 'delete'
  })
}
