import request from '@/utils/request'

export function fetchKubernetesList() {
  return request({
    url: '/k8s/namespace',
    method: 'get'
  })
}

export function fetchK8sdetail(query) {
  return request({
    url: '/k8s/service',
    method: 'get',
    params: query
  })
}

export function fetchUserrepository(data) {
  return request({
    url: '/k8s/repository',
    method: 'post',
    data
  })
}

export function fetchTaglist(data) {
  return request({
    url: '/k8s/tag',
    method: 'post',
    data
  })
}
export function getType() {
  return request({
    url: '/proconfig/get_type',
    method: 'get'
  })
}
export function CreateCluService(data) {
  return request({
    url: '/k8s/service/create',
    method: 'post',
    data
  })
}
export function fetchServiceDetails(data) {
  return request({
    url: '/k8s/service/details',
    method: 'post',
    data
  })
}

export function getNamespaceTemplate() {
  return request({
    url: '/docker/get_namespace_template_new',
    method: 'get'
  })
}

export function getSystemByType() {
  return request({
    url: '/docker/get_systems_by_type_new',
    method: 'get'
  })
}

export function initNamespace(data) {
  return request({
    url: '/k8s/namespace/init',
    method: 'post',
    data
  })
}
