# 测试环境
> 组成

- qahome-diamond
- qa-api
- tke-eos
- global-jenkinsfile
- qg-dockerfiles
- qg-docker-entryponits

[使用说明](http://confluence.quantgroup.cn/pages/viewpage.action?pageId=20548625)

[疑难杂症](http://confluence.quantgroup.cn/pages/viewpage.action?pageId=20546803)

## qahome-diamond
### 简介
qahome前端服务，所有工具的入口
### 代码仓库
git@git.quantgroup.cn:QA/qahome-diamond.git
### 部署方式
[Jenkins](http://192.168.4.96:8080/view/TKE/job/qahome-diamond/)


## qa-api
### 简介
qa环境中间层，负责数据持久化、审计、请求转发等
### 代码仓库
git@git.quantgroup.cn:QA/qa-api.git
### 部署方式
172.30.220.22 执行 `dp qa-api`

## tke-eos
### 简介
TKE交互层，负责与腾讯k8s的交互，将前端请求参数拼接成YAML发送给api-server
### 代码仓库
git@git.quantgroup.cn:QA/tke-eos.git
### 目录说明
```
app
├── cluster.js  集群相关
├── dailySyncDB.js  同步数据库
├── deleteTestSvc.js  定时任务
├── index.js 主文件
├── ingress.js ingress相关
├── namespace.js  ns相关
├── repository.js 仓库相关
├── restartLatest.js 重新部署定时任务
├── schedule.js 服务监控定时任务
├── service.js 服务操作
└── tag.js 镜像相关
```
### 部署方式
172.30.220.22 执行 `dp tke-eos`

## global-jenkinsfile
### 简介
jenkins pipeline插件脚本，用来描述pipeline过程
### 代码仓库
git@git.quantgroup.cn:QA/global-jenkinsfile.git
### 工作流

- [tke-java](http://192.168.4.96:8080/view/TKE/job/tke-java/)
- [tke-ui](http://192.168.4.96:8080/view/TKE/job/tke-ui/)
- [tke-node](http://192.168.4.96:8080/view/TKE/job/tke-node/)
- [tke-go](http://192.168.4.96:8080/view/TKE/job/tke-go/)
- [tke-sonar](http://192.168.4.96:8080/view/TKE/job/tke-sonar/)

![](static/readme/jenkins.png)

## qg-dockerfiles
### 简介
各类服务的Dockerfile模板
### 代码仓库
git@git.quantgroup.cn:QA/qg-dockerfiles.git
### 目录说明
```
tke
├── go
├── golang1.12
├── java
├── jdk1.8
├── mongod3.6
├── mvn3.5
├── mysql5.6
├── mysql5.7
├── mysql8
├── node10
├── node12
├── nodejs
├── openresty1.13 ui基础镜像
│   └── qa-replace
├── python
├── rabbitmq3.6
│   └── plugins
├── redash
├── redis3
│   └── confs
├── redis3sentinel
│   └── confs
├── ui
│   ├── conf
│   │   └── abTest
│   ├── lua
│   └── npmrc
└── zookeeper3.4
```


## qg-docker-entryponits
### 简介
镜像的入口执行文件，无需重新制作镜像即可更新入口脚本
### 代码仓库
git@git.quantgroup.cn:QA/qg-dockerfiles.git


# 工具
## ka-op-ui
### 简介
KA联调平台
### 代码仓库
git@git.quantgroup.cn:QA/ka-op-ui.git
### 结构说明
```
src
├── api api
├── assets
│   └── 404_images
├── components 组件
│   ├── Breadcrumb
│   ├── Hamburger
│   ├── Pagination
│   └── SvgIcon
├── directive 
│   └── permission 权限控制
├── icons
│   └── svg
├── router 路由
├── store vuex
│   └── modules
├── styles 样式
├── utils 
└── views 页面
    ├── channel
    ├── dashboard
    ├── layout
    │   ├── components
    │   │   └── Sidebar
    │   └── mixin
    ├── login
    ├── order
    ├── testorder
    └── user
```
### 部署方式
[Jenkins](http://192.168.4.96:8080/view/TKE/job/qahome-diamond/)


# TKE
## 节点
```
NAME          STATUS   ROLES    AGE    VERSION
172.17.5.12   Ready    <none>   162d   v1.10.5-tke.12
172.17.5.13   Ready    <none>   195d   v1.10.5-tke.10
172.17.5.14   Ready    <none>   86d    v1.10.5-tke.14
172.17.5.16   Ready    <none>   195d   v1.10.5-tke.10
172.17.5.17   Ready    <none>   195d   v1.10.5-tke.10
172.17.5.2    Ready    <none>   195d   v1.10.5-tke.10
172.17.5.5    Ready    <none>   195d   v1.10.5-tke.10
172.17.5.8    Ready    <none>   195d   v1.10.5-tke.10
172.17.5.9    Ready    <none>   200d   v1.10.5-tke.10
```
## 镜像仓库
![](static/readme/imageR.png)

# Q&A
## 服务起不来
将服务部署成调试模式，通过查看日志来定位问题，典型问题包括：

- 缺少数据库表
- 缺少MQ配置
- 缺少apollo配置，**尤其留意是否使用的k8s-mock，开发经常忘记给k8s-mock加配置**
- 代码本身问题
- 。。。

## 服务已经启动，但提示 Service Unavailable
- 检查 apollo k8s 端口配置是否是80
- 检查是否引用 commons-parent package

## 现有哪些服务器
```
172.30.220.43 ATM
172.30.220.24 chandao
172.21.10.121 redash
172.30.220.22 qahome
TKE节点
```

## 各个域名对应的服务部署在哪里
```
sshto 192.168.4.3
cd /usr/local/openresty/nginx/conf/conf.d
grep atm * -r
vi $grep_result
```

## 数据库同步脚本
修改`qa-deploy-utils`的`4.96`分支

```
sshto 192.168.4.96
cd /home/qa-deploy-utils/
git pull
```

## k8s参考
- 《kubernetes权威指南》 公司图书馆有这本书
- [k8s官方文档](https://kubernetes.io/docs/home/)
- [k8s中文文档](http://docs.kubernetes.org.cn/)
- [腾讯云容器服务](https://cloud.tencent.com/document/product/457)
