import request from '@/utils/request'

export function getAllRepos() {
  return request({
    url: '/repo/getAll'
  })
}

export function getBaseRepos() {
  return request({
    url: '/repo/getBase'
  })
}

export function getAppRepos() {
  return request({
    url: '/repo/getApp'
  })
}

export function getAllEnvTemplate() {
  return request({
    url: '/envTemplate/getAll'
  })
}

export function createEnvTemplate(data) {
  return request({
    url: '/envTemplate/create',
    method: 'post',
    data
  })
}

export function saveEnvTemplate(data) {
  return request({
    url: '/envTemplate/save',
    method: 'post',
    data
  })
}

export function deleteEnvTemplate(query) {
  return request({
    url: '/envTemplate/delete',
    method: 'get',
    params: query
  })
}

export function createEnv(data) {
  return request({
    url: '/env/create',
    method: 'post',
    data
  })
}

export function getGroup(query) {
  return request({
    url: '/env/get_group',
    method: 'get',
    params: query
  })
}

export function fetchKubernetesList() {
  return request({
    url: '/k8s/namespace',
    method: 'get'
  })
}

export function fetchK8sdetail(query) {
  return request({
    url: '/k8s/service',
    method: 'get',
    params: query
  })
}

export function redeployClusterService(data) {
  return request({
    url: '/k8s/service/redeploy',
    method: 'post',
    data
  })
}

export function deleteClusterService(data) {
  return request({
    url: '/k8s/service/delete',
    method: 'post',
    data
  })
}

export function fetchUserrepository(data) {
  return request({
    url: '/k8s/repository',
    method: 'post',
    data
  })
}

export function fetchTaglist(data) {
  return request({
    url: '/k8s/tag',
    method: 'post',
    data
  })
}

export function getType() {
  return request({
    url: '/proconfig/get_type',
    method: 'get'
  })
}

export function CreateCluService(data) {
  return request({
    url: '/k8s/service/create',
    method: 'post',
    data
  })
}

export function modifyCluService(data) {
  return request({
    url: '/k8s/service/modifyImage',
    method: 'post',
    data
  })
}

export function modifyDeploy(data) {
  return request({
    url: '/k8s/service/modifyDeploy',
    method: 'post',
    data
  })
}

export function fetchServiceDetails(data) {
  return request({
    url: '/k8s/service/details',
    method: 'post',
    data
  })
}

export function fetchServiceInstance(data) {
  return request({
    url: '/k8s/service/instance',
    method: 'post',
    data
  })
}

export function flushRedis(query) {
  return request({
    url: '/docker/flush_redis_tke',
    method: 'get',
    params: query
  })
}

export function reloadMq(data) {
  return request({
    url: '/docker/reload_mq',
    method: 'post',
    data
  })
}

export function mqDiff(data) {
  return request({
    url: '/docker/mqDiff',
    method: 'post',
    data
  })
}

export function ingressHost(query) {
  return request({
    url: '/k8s/ingress',
    method: 'get',
    params: query
  })
}

export function modifyIngressHost(data) {
  return request({
    url: '/k8s/ingress/modify',
    method: 'post',
    data
  })
}

// export function initNamespace(data) {
//   return request({
//     url: '/k8s/namespace/init',
//     method: 'post',
//     data
//   })
// }
